/*	SCCS Id: @(#)monst.c	3.0	89/03/11
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

/* since this file is also used in auxiliary programs, don't include all the
 * function declarations for all of nethack
 */
#define EXTERN_H
#include "config.h"
#include "permonst.h"
#include "monsym.h"
#include "eshk.h"
#include "vault.h"
#include "epri.h"

#define	NO_ATTK		{ 0, 0, 0, 0 }

#ifndef SPLITMON_2
struct permonst playermon = {		/* used by weapons bonus code */
	"player", S_HUMAN, 1, 10, 10, 0, 0, G_GENO | G_NOGEN,
	{ { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	45, 400, PL_NSIZ, MS_SILENT, M1_HUMANOID | M1_COLLECT,
	M2_HUMAN | M2_STRONG | M2_NEEDPICK
},	*uasmon = &playermon;
#endif /* SPLITMON_2 */

/*
 *	Rule #1:	monsters of a given class are contiguous in the
 *			mons[] array.
 *
 *	Rule #2:	monsters of a given class are presented in ascending
 *			order of strength.
 *
 *	Rule #3:	monster frequency is included in the geno mask;
 *			the frequency can be from 0 to 7.  0's will also
 *			be skipped during generation.
 */

#ifndef SPLITMON_2
struct permonst mons[] = {
/*	ants	*/
	{ "giant ant",	S_ANT, 2, 18, 3, 0, 0, (G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_EGGS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "soldier ant", S_ANT, 3, 18, 3, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_STNG, AD_DRST, 3, 4 },
	  NO_ATTK, NO_ATTK, NO_ATTK }, 2, 20, 0, MS_SILENT,
	  M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_EGGS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "fire ant", S_ANT, 3, 18, 3, 10, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_FIRE, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_EGGS |
	  M1_FIRE_RES, M2_HOSTILE | M2_CARNIVORE },
	{ "giant beetle", S_ANT, 5, 6, 4, 0, 0, (G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_NOHANDS | M1_POIS |
	  M1_POIS_RES, M2_HOSTILE | M2_CARNIVORE },
	{ "killer bee", S_ANT, 1, 18, -4, 0, 0, (G_GENO | G_LGROUP | 2),
	  { { AT_STNG, AD_DRST, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_BUZZ, M1_VSMALL | M1_ANIMAL | M1_FLY | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES, M2_HOSTILE },
	{ "queen bee", S_ANT, 9, 24, -6, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_STNG, AD_DRST, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_BUZZ, M1_VSMALL | M1_ANIMAL | M1_FLY | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES | M1_PRINCE, M2_HOSTILE },
/*	blobs	*/
	{ "acid blob", S_BLOB, 1, 3, 8, 0, 0, (G_GENO | 2),
	  { { AT_NONE, AD_ACID, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, M1_VSMALL | M1_NOEYES | M1_NOHANDS |
	  M1_POIS | M1_SLEE_RES | M1_STON_RES,
	  M2_WANDER | M2_NOLIMBS | M2_AMORPHOUS },
	{ "gelatinous cube", S_BLOB, 6, 6, 8, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_PLYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_BIG | M1_NOEYES | M1_NOHANDS |
	  M1_FIRE_RES | M1_COLD_RES | M1_ELEC_RES | M1_SLEE_RES,
	  M2_WANDER | M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE },
	{ "quivering blob", S_BLOB, 5, 1, 8, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_NOEYES | M1_NOHANDS | M1_POIS_RES,
	  M2_WANDER | M2_HOSTILE | M2_NOLIMBS },
/*	cockatrice	*/
	{ "cockatrice", S_COCKATRICE, 5, 6, 6, 30, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 1, 3 }, { AT_TUCH, AD_STON, 0, 0 },
	  NO_ATTK, NO_ATTK, NO_ATTK }, 3, 30, 0, MS_HISS, M1_VSMALL |
	  M1_ANIMAL | M1_NOHANDS | M1_EGGS | M1_POIS_RES | M1_STON_RES,
	  M2_HOSTILE },
/*	dog	*/
	{ "little dog", S_DOG, 2, 18, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_BARK,
	  M1_VSMALL | M1_ANIMAL | M1_NOHANDS, M2_CARNIVORE },
	{ "dog", S_DOG, 4, 16, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1 ,6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_BARK, M1_ANIMAL | M1_NOHANDS, M2_CARNIVORE },
	{ "large dog", S_DOG, 6, 15, 4, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, M1_ANIMAL | M1_NOHANDS, 
	  M2_STRONG | M2_CARNIVORE },
	{ "jackal", S_DOG, 0, 12, 7, 0, 0, (G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, M1_VSMALL | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "jackalwere", S_DOG, 2, 12, 7, 10, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, M1_NOPOLY | M1_WERE | M1_NOHANDS | M1_POIS |
	  M1_REGEN, M2_HOSTILE | M2_CARNIVORE },
	{ "wolf", S_DOG, 5, 12, 4, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK,
	  M1_ANIMAL | M1_NOHANDS, M2_HOSTILE | M2_CARNIVORE },
	{ "wolfwere", S_DOG, 5, 12, 4, 20, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, M1_NOPOLY | M1_WERE | M1_NOHANDS | M1_POIS |
	  M1_REGEN, M2_HOSTILE | M2_CARNIVORE },
	{ "winter wolf", S_DOG, 7, 12, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_BREA, AD_COLD, 2, 6 },
	  NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_BARK, M1_BIG | M1_ANIMAL | M1_NOHANDS | M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
	{ "warg", S_DOG, 7, 12, 4, 0, -5, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_BARK, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "hell hound pup", S_DOG, 7, 12, 4, 20, -5,
	  (G_HELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_BREA, AD_FIRE, 2, 6 },
	  NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_BARK, M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "hell hound", S_DOG, 12, 14, 2, 20, 0, (G_HELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BREA, AD_FIRE, 3, 6 },
	  NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_BARK, M1_BIG | M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
#ifdef CHARON
	{ "Cerberus", S_DOG, 12, 10, 2, 20, -7, (G_HELL | G_UNIQ | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BITE, AD_PHYS, 3, 6 },
	  { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK },
	  50, 350, 0, MS_BARK, M1_NOPOLY | M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
#endif
/*	eyes	*/
	{ "floating eye", S_EYE, 2, 1, 9, 10, 0, (G_GENO | 5),
	  { { AT_NONE, AD_PLYS, 0, 70 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, M1_FLY | M1_NOHANDS, M2_HOSTILE | M2_NOLIMBS },
	{ "freezing sphere", S_EYE, 6, 13, 4, 0, 0, (G_GENO | 2),
	  { { AT_EXPL, AD_COLD, 4, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, M1_FLY | M1_NOHANDS | M1_COLD_RES, M2_HOSTILE |
	  M2_NOLIMBS },
/*	felines		*/
	{ "kitten", S_FELINE, 2, 18, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_MEW, M1_VSMALL | M1_ANIMAL | M1_NOHANDS,
	  M2_WANDER | M2_CARNIVORE },
	{ "housecat", S_FELINE, 4, 16, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1 ,6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_MEW, M1_ANIMAL | M1_NOHANDS, M2_CARNIVORE },
	{ "large cat", S_FELINE, 6, 15, 4, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_MEW, M1_BIG | M1_ANIMAL | M1_NOHANDS,
	  M2_STRONG | M2_CARNIVORE },
	{ "jaguar", S_FELINE, 5, 15, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 8 }, { AT_CLAW, AD_PHYS, 1, 8 },
	    { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_GROWL, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
/*	gremlins	*/
	{ "gremlin", S_GREMLIN, 5, 12, 2, 25, -9, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	  { AT_BITE, AD_PHYS, 1, 4 }, { AT_CLAW, AD_CURS, 0, 0 }, NO_ATTK },
	  10, 30, 0, MS_LAUGH, M1_VSMALL | M1_SWIM | M1_HUMANOID | M1_POIS |
	  M1_STALK, 0 },
/*	humanoids	*/
#ifdef TOLKIEN
	{ "hobbit", S_HUMANOID, 1, 9, 7, 0, 6, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_HUMANOID, M1_HUMANOID | M1_COLLECT, 0 },
#endif
	{ "bugbear", S_HUMANOID, 3, 9, 5, 0, -6, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_GROWL, M1_BIG | M1_HUMANOID | M1_COLLECT,
	  M2_STRONG },
	{ "dwarf", S_HUMANOID,	2, 6, 4, 10, 4, (G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_HUMANOID, M1_HUMANOID | M1_GREEDY | M1_JEWELS |
	  M1_COLLECT, M2_DWARF | M2_TUNNEL | M2_NEEDPICK | M2_STRONG },
	{ "dwarf lord", S_HUMANOID,  4, 6, 4, 10, 5, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_HUMANOID,
	  M1_HUMANOID | M1_LORD | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_DWARF | M2_TUNNEL | M2_NEEDPICK | M2_STRONG },
	{ "dwarf king", S_HUMANOID,  6, 6, 4, 20, 6, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_HUMANOID,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT | M1_PRINCE,
	  M2_DWARF | M2_TUNNEL | M2_NEEDPICK | M2_STRONG },
/*	imps & other minor demons/devils */
	{ "manes", S_IMP, 1, 3, 7, 0, -7, (G_GENO | G_LGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_JEER, M1_VSMALL | M1_POIS | M1_STALK, 0 },
	{ "homunculus", S_IMP, 2, 12, 6, 10, -7, (G_GENO | 2),
	  { { AT_BITE, AD_SLEE, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, M1_VSMALL | M1_FLY | M1_POIS | M1_POIS_RES |
	  M1_SLEE_RES | M1_STALK, 0 },
	{ "lemure", S_IMP, 3, 3, 7, 0, -7,
	  (G_HELL | G_GENO | G_LGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_POIS | M1_SLEE_RES | M1_REGEN | M1_STALK,
	  M2_HOSTILE | M2_WANDER },
	{ "imp", S_IMP, 3, 12, 2, 20, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_JEER, M1_VSMALL | M1_REGEN | M1_STALK,
	  M2_WANDER },
	{ "quasit", S_IMP, 3, 15, 2, 20, -7, (G_GENO | 2),
	  { { AT_CLAW, AD_DRDX, 1, 2 }, { AT_CLAW, AD_DRDX, 1, 2 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, M1_VSMALL | M1_POIS_RES | M1_REGEN | M1_STALK,
	  0 },
	{ "tengu", S_IMP, 6, 13, 5, 30, 7, (G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 1, 7 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_SQAWK, M1_VSMALL | M1_POIS_RES | M1_TPORT |
	  M1_TPORT_CONTROL | M1_STALK, 0 },
/*	j ??? */
/*	kobolds 	*/
	{ "kobold", S_KOBOLD,  0, 6, 7, 0, -2, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_ORC, M1_HUMANOID | M1_POIS | M1_COLLECT,
	  M2_HOSTILE },
	{ "large kobold", S_KOBOLD,  1, 6, 6, 0, -3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_ORC, M1_HUMANOID | M1_POIS | M1_COLLECT,
	  M2_HOSTILE },
	{ "kobold lord", S_KOBOLD,  2, 6, 5, 0, -4, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC, M1_HUMANOID | M1_POIS | M1_COLLECT | M1_LORD,
	  M2_HOSTILE },
	{ "kobold shaman", S_KOBOLD, 1, 6, 6, 10, -4, (G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_ORC, M1_HUMANOID | M1_POIS | M1_MAGIC, M2_HOSTILE },
/*	liches	 */
	{ "lich", S_LICH, 11, 6, 0, 30, -9, (G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 1, 10 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 100, 0, MS_MUMBLE, M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_COLD_RES | M1_REGEN, M2_HOSTILE },
	{ "demilich", S_LICH, 14, 9, -2, 60, -12, (G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 3, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 100, 0, MS_MUMBLE, M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_COLD_RES | M1_REGEN, M2_HOSTILE },
	{ "master lich", S_LICH, 17, 9, -4, 90, -15, (G_HELL | G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 3, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 100, 0, MS_MUMBLE, M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_FIRE_RES | M1_COLD_RES | M1_REGEN, M2_HOSTILE },
/*	mimics	*/
	{ "small mimic", S_MIMIC, 7, 3, 7, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, M1_ANIMAL | M1_NOEYES | M1_NOHANDS,
	  M2_HOSTILE | M2_HIDE | M2_NOLIMBS | M2_CARNIVORE },
	{ "large mimic", S_MIMIC, 8, 3, 7, 10, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_STCK, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_NOEYES | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_HIDE | M2_NOLIMBS | M2_CARNIVORE },
	{ "giant mimic", S_MIMIC, 9, 3, 7, 20, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_STCK, 3, 6 }, { AT_CLAW, AD_STCK, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 500, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_NOEYES | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_HIDE | M2_NOLIMBS | M2_CARNIVORE },
/*	nagas	*/
	{ "red naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, M1_BIG | M1_NOHANDS | M1_POIS_RES |
	  M1_FIRE_RES, M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
	{ "black naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, M1_BIG | M1_NOHANDS | M1_POIS_RES |
	  M1_STON_RES, M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
	{ "golden naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, M1_BIG | M1_NOHANDS | M1_POIS_RES, M2_STRONG |
	  M2_NOLIMBS | M2_THICK_HIDE },
	{ "guardian naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, M1_BIG | M1_NOHANDS | M1_POIS_RES, M2_STRONG |
	  M2_NOLIMBS | M2_THICK_HIDE },
	{ "red naga", S_NAGA, 6, 12, 4, 0, -4, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_BREA, AD_FIRE, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 60, 400, 0, MS_MUMBLE,
	  M1_BIG | M1_NOHANDS | M1_EGGS | M1_POIS_RES | M1_FIRE_RES,
	  M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
	{ "black naga", S_NAGA, 8, 14, 2, 10, 4, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_SPIT, AD_ACID, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 60, 400, 0, MS_MUMBLE,
	  M1_BIG | M1_NOHANDS | M1_EGGS | M1_POIS | M1_POIS_RES | M1_STON_RES,
	  M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
	{ "golden naga", S_NAGA, 10, 14, 2, 70, 5, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_MAGC, AD_SPEL, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 400, 0, MS_MUMBLE, M1_BIG | M1_NOHANDS | M1_EGGS | M1_POIS_RES,
	  M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
	{ "guardian naga", S_NAGA, 12, 16, 0, 50, 7, (G_GENO | 1),
	  { { AT_BITE, AD_PLYS, 1, 6 }, { AT_HUGS, AD_PHYS, 2, 4 },
	    { AT_SPIT, AD_ACID, 1, 6 }, NO_ATTK, NO_ATTK },
	  60, 400, 0, MS_MUMBLE, M1_BIG | M1_NOHANDS | M1_EGGS | M1_POIS_RES,
	  M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
/*	orcs 	*/
	{ "goblin", S_ORC,  0, 6, 6, 0, -3, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_ORC, M1_HUMANOID | M1_COLLECT, M2_ORC },
	{ "hobgoblin", S_ORC,  1, 9, 6, 0, -4, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC, M1_HUMANOID | M1_COLLECT, M2_ORC | M2_STRONG },
	/* "orc" for zombie corpses only; they don't get created at random */
	{ "orc", S_ORC,  1, 9, 6, 0, -3, (G_GENO | G_NOGEN | G_LGROUP),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_ORC,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG },
	{ "hill orc", S_ORC, 2, 9, 6, 0, -4, (G_GENO | G_LGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG },
#ifdef TOLKIEN
	{ "Mordor orc", S_ORC, 3, 5, 6, 0, -5, (G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG },
	{ "Uruk-hai", S_ORC, 3, 7, 5, 0, -4, (G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_ORC,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG },
#endif
	{ "orc shaman", S_ORC, 3, 9, 5, 10, -5, (G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_ORC, M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_ORC | M2_HOSTILE | M2_STRONG },
	{ "orc-captain", S_ORC, 5, 5, 4, 0, -5, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_ORC,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG },
/*	 piercers	*/
	{ "rock piercer", S_PIERCER, 3, 1, 3, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, M1_ANIMAL | M1_NOEYES | M1_NOHANDS,
	  M2_HOSTILE | M2_HIDE | M2_NOLIMBS | M2_CARNIVORE },
	{ "iron piercer", S_PIERCER, 5, 1, 0, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 300, 0, MS_SILENT, M1_ANIMAL | M1_NOEYES | M1_NOHANDS,
	  M2_HOSTILE | M2_HIDE | M2_NOLIMBS | M2_CARNIVORE },
/*	quadrupeds (generic)	*/
	{ "rothe", S_QUADRUPED, 2, 9, 7, 0, 0, (G_GENO | G_SGROUP | 4),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "osquip", S_QUADRUPED, 3, 12, 7, 0, 0, (G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
#ifdef TOLKIEN
	{ "mumakil", S_QUADRUPED, 5, 9, 0, 0, -2, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 4, 12 }, { AT_BITE, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 500, 0, MS_SILENT, M1_ANIMAL | M1_NOHANDS | M1_BIG,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
#endif
	{ "leocrotta", S_QUADRUPED, 6, 18, 4, 10, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_BITE, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_IMITATE, M1_BIG | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
	{ "wumpus", S_QUADRUPED, 8, 3, 2, 10, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
	{ "titanothere", S_QUADRUPED, 12, 12, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  65, 650, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baluchitherium", S_QUADRUPED, 14, 12, 5, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 5, 4 }, { AT_CLAW, AD_PHYS, 5, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  80, 800, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_HERBIVORE | M2_THICK_HIDE },
/*	rodents 	*/
	{ "sewer rat",	S_RODENT, 0, 12, 7, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SQEEK, M1_VSMALL | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "giant rat",	S_RODENT, 1, 10, 7, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SQEEK, M1_VSMALL | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "rabid rat", S_RODENT, 2, 12, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRCO, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 10, 0, MS_SQEEK, M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_POIS,
	  M2_HOSTILE | M2_CARNIVORE },
	{ "ratwere", S_RODENT, 2, 12, 6, 10, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SQEEK, M1_VSMALL | M1_WERE | M1_NOHANDS | M1_NOPOLY |
	  M1_POIS | M1_REGEN, M2_HOSTILE | M2_CARNIVORE },
	{ "rock mole", S_RODENT, 3, 3, 0, 20, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, M1_VSMALL | M1_ANIMAL | M1_NOHANDS |
	  M1_GREEDY | M1_JEWELS | M1_COLLECT, M2_HOSTILE | M2_TUNNEL },
/*	spiders and scorpions	*/
	{ "cave spider", S_SPIDER, 1, 12, 3, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 50, 0, MS_SILENT, M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_EGGS |
	  M1_POIS_RES, M2_HOSTILE | M2_CONCEAL | M2_CARNIVORE },
	{ "scorpion", S_SPIDER, 5, 15, 3, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    { AT_STNG, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_VSMALL | M1_ANIMAL | M1_NOHANDS | M1_EGGS |
	  M1_POIS, M2_HOSTILE | M2_CONCEAL | M2_CARNIVORE },
	{ "giant spider", S_SPIDER, 5, 15, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT,
	  M1_BIG | M1_ANIMAL | M1_NOHANDS | M1_EGGS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
/*	trappers, lurkers, etc...	*/
	{ "lurker above", S_TRAPPER, 10, 3, 3, 0, 0, (G_GENO | 2),
	  { { AT_ENGL, AD_DGST, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 350, 0, MS_SILENT,
	  M1_BIG | M1_ANIMAL | M1_NOEYES | M1_NOHANDS | M1_STALK | M1_FLY,
	  M2_HOSTILE | M2_STRONG | M2_NOLIMBS | M2_CARNIVORE },
	{ "trapper", S_TRAPPER, 12, 3, 3, 0, 0, (G_GENO | 2),
	  { { AT_ENGL, AD_DGST, 1, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 350, 0, MS_SILENT,
	  M1_BIG | M1_ANIMAL | M1_NOEYES | M1_NOHANDS | M1_STALK,
	  M2_HOSTILE | M2_STRONG | M2_NOLIMBS | M2_CARNIVORE },
/*	unicorns	*/
	{ "white unicorn", S_UNICORN, 4, 24, 2, 70, 7, (G_GENO | 2),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_NEIGH, M1_BIG | M1_NOHANDS | M1_POIS_RES | M1_JEWELS,
	  M2_WANDER | M2_STRONG | M2_HERBIVORE },
	{ "grey unicorn", S_UNICORN, 4, 24, 2, 70, 0, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_NEIGH, M1_BIG | M1_NOHANDS | M1_POIS_RES | M1_JEWELS,
	  M2_WANDER | M2_STRONG | M2_HERBIVORE },
	{ "black unicorn", S_UNICORN, 4, 24, 2, 70, -7, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_NEIGH, M1_BIG | M1_NOHANDS | M1_POIS_RES | M1_JEWELS,
	  M2_WANDER | M2_STRONG | M2_HERBIVORE },
/*	vortices	*/
	{ "fog cloud",	S_VORTEX, 3,  1, 0, 0, 0, (G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 0, 0, MS_SILENT,
	  M1_FLY | M1_NOEYES | M1_NOHANDS | M1_POIS_RES, M2_HOSTILE |
	  M2_NOLIMBS },
	{ "dust vortex", S_VORTEX, 4, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_BLND, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 0, 0, MS_SILENT,
	  M1_FLY | M1_NOEYES | M1_NOHANDS | M1_POIS_RES, M2_HOSTILE |
	  M2_NOLIMBS },
	{ "energy vortex", S_VORTEX, 6, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_ENGL, AD_ELEC, 1, 6 }, { AT_ENGL, AD_DREN, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 20, 0, 0, MS_SILENT,
	  M1_FLY | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_ELEC_RES,
	  M2_HOSTILE | M2_NOLIMBS },
	{ "ice vortex", S_VORTEX, 5, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_ENGL, AD_COLD, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT,
	  M1_FLY | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_COLD_RES,
	  M2_HOSTILE | M2_NOLIMBS },
	{ "steam vortex", S_VORTEX, 7, 22, 2, 30, 0,
	  (G_HELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_FIRE, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT,
	  M1_FLY | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_FIRE_RES,
	  M2_HOSTILE | M2_NOLIMBS },
	{ "fire vortex", S_VORTEX, 8, 22, 2, 30, 0,
	  (G_HELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_ENGL, AD_FIRE, 1, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 0, 0, MS_SILENT,
	  M1_FLY | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_FIRE_RES,
	  M2_HOSTILE | M2_NOLIMBS },
/*	worms	*/
#ifdef WORM
	{ "baby long worm", S_WORM, 8, 3, 5, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_SILENT, M1_ANIMAL | M1_NOHANDS, M2_HOSTILE |
	  M2_NOLIMBS | M2_CARNIVORE },
#endif
	{ "baby purple worm", S_WORM, 8, 3, 5, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_SILENT, M1_ANIMAL | M1_NOHANDS, M2_HOSTILE |
	  M2_NOLIMBS | M2_CARNIVORE },
#ifdef WORM
	{ "long worm", S_WORM, 8, 3, 5, 10, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT,
	  M1_BIG | M1_ANIMAL | M1_NOHANDS | M1_NOPOLY | M1_EGGS,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_NOLIMBS | M2_CARNIVORE },
#endif
	{ "purple worm", S_WORM, 15, 9, 6, 20, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 8 }, { AT_ENGL, AD_DGST, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 70, 700, 0, MS_SILENT,
	  M1_BIG | M1_ANIMAL | M1_NOHANDS | M1_EGGS,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_NOLIMBS | M2_CARNIVORE },
/*	xan	*/
	{ "xan", S_XAN, 7, 18, -4, 0, 0, (G_GENO | 3),
	  { { AT_STNG, AD_LEGS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_BUZZ, M1_VSMALL | M1_FLY | M1_ANIMAL | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES, M2_HOSTILE },
/*	yellow light	*/
	{ "yellow light", S_YLIGHT,  3, 15, 0, 0, 0, (G_GENO | 4),
	  { { AT_EXPL, AD_BLND, 10, 20 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, M1_FLY | M1_NOHANDS, M2_HOSTILE | M2_NOLIMBS },
/*	zruty	*/
	{ "zruty", S_ZRUTY, 9, 8, 3, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK },
	  60, 600, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
/*	Apes	*/
	{ "ape", S_APE, 4, 12, 6, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_GROWL, M1_BIG | M1_ANIMAL | M1_HUMANOID,
	  M2_STRONG | M2_CARNIVORE },
	{ "carnivorous ape", S_APE, 5, 12, 6, 0, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_HUGS, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK },
	  55, 550, 0, MS_GROWL, M1_BIG | M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
/*	Bats	*/
	{ "bat", S_BAT, 0, 22, 8, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SQEEK, M1_VSMALL | M1_FLY | M1_ANIMAL | M1_NOHANDS,
	  M2_WANDER | M2_CARNIVORE },
	{ "giant bat", S_BAT, 2, 22, 7, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SQEEK, M1_FLY | M1_ANIMAL | M1_NOHANDS,
	  M2_WANDER | M2_HOSTILE | M2_CARNIVORE },
	{ "vampire bat", S_BAT, 5, 20, 6, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRST, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 20, 0, MS_SQEEK, M1_VSMALL | M1_FLY | M1_ANIMAL | M1_UNDEAD |
	  M1_NOHANDS | M1_POIS | M1_REGEN, M2_HOSTILE },
/*	Centaurs	*/
	{ "plains centaur", S_CENTAUR, 4, 18, 4, 0, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_BIG | M1_COLLECT | M1_GREEDY, M2_STRONG },
	{ "forest centaur", S_CENTAUR, 5, 18, 3, 10, -1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  55, 600, 0, MS_SILENT, M1_BIG | M1_COLLECT | M1_GREEDY, M2_STRONG },
	{ "mountain centaur", S_CENTAUR, 6, 20, 2, 10, -3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 10 }, { AT_KICK, AD_PHYS, 1, 6 },
	    { AT_KICK, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK },
	  55, 500, 0, MS_SILENT, M1_BIG | M1_COLLECT | M1_GREEDY, M2_STRONG },
/*	Dragons 	*/
	{ "baby grey dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby red dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS | M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby white dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS | M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby blue dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS | M1_ELEC_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby green dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS | M1_POIS |
	  M1_POIS_RES, M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby orange dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS | M1_SLEE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby black dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "baby yellow dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR,
	  M1_BIG | M1_FLY | M1_NOHANDS | M1_GREEDY | M1_JEWELS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_THICK_HIDE },
	{ "grey dragon", S_DRAGON, 10, 9, -1, 20, 4, (G_GENO | 1),
	  { { AT_BREA, AD_MAGM, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "red dragon", S_DRAGON, 10, 9, -1, 20, -4, (G_GENO | 1),
	  { { AT_BREA, AD_FIRE, 6, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_FIRE_RES | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "orange dragon", S_DRAGON, 10, 9, -1, 20, 5, (G_GENO | 1),
	  { { AT_BREA, AD_SLEE, 4, 25 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_SLEE_RES | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "white dragon", S_DRAGON, 10, 9, -1, 20, -5, (G_GENO | 1),
	  { { AT_BREA, AD_COLD, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_COLD_RES | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "black dragon", S_DRAGON, 10, 9, -1, 20, -6, (G_GENO | 1),
	  { { AT_BREA, AD_DISN, 4, 10 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "blue dragon", S_DRAGON, 10, 9, -1, 20, -7, (G_GENO | 1),
	  { { AT_BREA, AD_ELEC, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_ELEC_RES | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "green dragon", S_DRAGON, 10, 9, -1, 20, 6, (G_GENO | 1),
	  { { AT_BREA, AD_DRST, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_POIS | M1_POIS_RES | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
	{ "yellow dragon", S_DRAGON, 10, 9, -1, 20, 7, (G_GENO | 1),
	  { { AT_BREA, AD_ACID, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, M1_BIG | M1_FLY | M1_SEE_INVIS | M1_NOHANDS |
	  M1_EGGS | M1_POIS | M1_STON_RES | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_THICK_HIDE },
/*	Elementals	*/
	{ "air elemental", S_ELEMENTAL, 8, 36, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_ENGL, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 0, 0, MS_SILENT,
	  M1_BIG | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_FLY,
	  M2_STRONG | M2_NOLIMBS },
	{ "fire elemental", S_ELEMENTAL, 8, 12, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_FIRE, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 0, 0, MS_SILENT,
	  M1_BIG | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_FLY | M1_FIRE_RES,
	  M2_STRONG | M2_NOLIMBS },
	{ "earth elemental", S_ELEMENTAL, 8, 6, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 4, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 0, 0, MS_SILENT,
	  M1_BIG | M1_WALLWALK | M1_NOEYES | M1_NOHANDS | M1_POIS_RES |
	  M1_STON_RES, M2_STRONG | M2_NOLIMBS | M2_THICK_HIDE },
	{ "water elemental", S_ELEMENTAL, 8, 6, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 5, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 0, 0, MS_SILENT,
	  M1_BIG | M1_NOEYES | M1_NOHANDS | M1_POIS_RES | M1_SWIM,
	  M2_STRONG | M2_NOLIMBS },
/*	Fungi	*/
	{ "violet fungus", S_FUNGUS, 3, 1, 7, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_PHYS, 1, 4 }, { AT_TUCH, AD_STCK, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 10, 100, 0, MS_SILENT, M1_VSMALL |
	  M1_NOEYES | M1_NOHANDS | M1_POIS_RES,
	  M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE },
	{ "brown mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 1),
	  { { AT_NONE, AD_COLD, 0, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, M1_VSMALL | M1_NOEYES | M1_NOHANDS |
	  M1_POIS_RES | M1_COLD_RES, M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE },
	{ "yellow mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 2),
	  { { AT_NONE, AD_STUN, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, M1_VSMALL | M1_NOEYES | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES, M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE },
	{ "green mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 1),
	  { { AT_NONE, AD_ACID, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, M1_VSMALL | M1_NOEYES | M1_NOHANDS |
	  M1_POIS | M1_STON_RES, M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE },
	{ "red mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 1),
	  { { AT_NONE, AD_FIRE, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, M1_VSMALL | M1_NOEYES | M1_NOHANDS |
	  M1_POIS_RES | M1_FIRE_RES, M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE },
/*	Gnomes	*/
	{ "gnome", S_GNOME, 1, 6, 5, 4, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_ORC, M1_HUMANOID | M1_COLLECT, 0 },
	{ "gnome lord", S_GNOME, 3, 8, 4, 4, 0, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 120, 0, MS_ORC, M1_HUMANOID | M1_COLLECT | M1_LORD, 0 },
	{ "gnome king", S_GNOME, 5, 10, 2, 20, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 150, 0, MS_ORC, M1_HUMANOID | M1_COLLECT | M1_PRINCE, 0 },
	{ "gnomish wizard", S_GNOME, 3, 10, 4, 10, 0, (G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 120, 0, MS_ORC, M1_HUMANOID | M1_MAGIC, 0 },
#ifdef SPLITMON_1
};
#endif
#endif /* !SPLITMON_2 */

/* horrible kludge alert: splitting monst.o into two parts depends on
   the two files monst1.o and monst2.o being loaded consecutively into
   memory, i.e. _mons2 must immediately follow mons. Needless to say,
   don't depend on this unless you have to (I had to; my compiler was
   too much of a memory pig to produce monst.o in a measly 2 megabytes
   of memory -- ERS */

#ifndef SPLITMON_1
#ifdef SPLITMON_2
struct permonst _mons2[] = {
#endif
/*	giant Humanoids */
	{ "ettin", S_GIANT, 10, 12, 3, 0, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_GRUNT, M1_BIG | M1_ANIMAL | M1_HUMANOID | M1_COLLECT,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE },
	{ "giant", S_GIANT, 6, 6, 0, 0, 2, (G_GENO | G_NOGEN | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_COLLECT | M1_JEWELS,
	   M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY },
	{ "stone giant", S_GIANT, 6, 6, 0, 0, 2, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_COLLECT | M1_JEWELS,
	   M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY },
	{ "hill giant", S_GIANT, 8, 10, 6, 0, -2, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_COLLECT | M1_JEWELS,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY },
	{ "fire giant", S_GIANT, 9, 12, 4, 5, 2, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_FIRE_RES | M1_COLLECT | M1_JEWELS,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY },
	{ "frost giant", S_GIANT, 10, 12, 3, 10, -3, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 12 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_COLD_RES | M1_COLLECT | M1_JEWELS,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY },
	{ "titan", S_GIANT, 16, 18, -3, 70, 9, 1,
	  { { AT_WEAP, AD_PHYS, 2, 8 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  90, 900, 0, MS_SILENT, M1_BIG | M1_FLY | M1_HUMANOID | M1_MAGIC |
	  M1_COLLECT, M2_STRONG | M2_ROCKTHROW | M2_NASTY },
	{ "minotaur", S_GIANT, 15, 15, 6, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 3, 10 }, { AT_CLAW, AD_PHYS, 3, 10 },
	    AT_BUTT, AD_PHYS, 2, 8, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE },
	{ "owlbear", S_GIANT, 5, 12, 5, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_HUGS, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_SILENT, M1_BIG | M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE },
/*	Invisible stalker	*/
	{ "stalker", S_STALKER, 8, 12, 3, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT,
	  M1_BIG | M1_ANIMAL | M1_FLY | M1_SEE_INVIS | M1_STALK,
	  M2_WANDER | M2_HOSTILE | M2_STRONG },
/*	Jellies 	*/
	{ "blue jelly", S_JELLY, 4, 0, 8, 10, 0, (G_GENO | 2),
	  { { AT_NONE, AD_COLD, 0, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, M1_BIG | M1_NOEYES | M1_NOHANDS |
	  M1_POIS_RES | M1_COLD_RES,
	  M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE | M2_AMORPHOUS },
	{ "spotted jelly", S_JELLY, 5, 0, 8, 10, 0, (G_GENO | 1),
	  { { AT_NONE, AD_ACID, 0, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT,
	  M1_BIG | M1_NOEYES | M1_NOHANDS | M1_POIS | M1_STON_RES,
	  M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE | M2_AMORPHOUS },
	{ "ochre jelly", S_JELLY, 6, 3, 8, 20, 0, (G_GENO | 2),
	  { { AT_ENGL, AD_ACID, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, M1_BIG | M1_NOEYES | M1_NOHANDS | M1_POIS |
	  M1_STON_RES, M2_HOSTILE | M2_OMNIVORE | M2_NOLIMBS | M2_AMORPHOUS },
/*	Kops	*/
#ifdef KOPS
	{ "Keystone Kop", S_KOP, 1, 6, 7, 10, 9, (G_GENO | G_LGROUP | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE },
	{ "Kop Sergeant", S_KOP, 2, 8, 6, 10, 10, (G_GENO | G_SGROUP | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG },
	{ "Kop Lieutenant", S_KOP, 3, 10, 5, 20, 11, (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG },
	{ "Kop Kaptain", S_KOP, 4, 12, 4, 20, 12, (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG },
#endif
/*	Leprechauns	*/
	{ "leprechaun", S_LEPRECHAUN, 5, 15, 8, 20, 0, (G_GENO | 4),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_SGLD, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_LAUGH, M1_HUMANOID | M1_TPORT | M1_GREEDY,
	  M2_HOSTILE },
/* 	Mummies		*/
	{ "kobold mummy", S_MUMMY, 3, 8, 6, 20, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS, M2_HOSTILE },
	{ "gnome mummy", S_MUMMY, 4, 10, 6, 20, -3, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS, M2_HOSTILE },
	{ "orc mummy", S_MUMMY, 5, 10, 5, 20, -4, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_SILENT, M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_GREEDY | M1_JEWELS, M2_HOSTILE | M2_ORC },
	{ "elf mummy", S_MUMMY, 6, 12, 4, 30, -5, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_SILENT, M1_HUMANOID | M1_UNDEAD | M1_POIS | M1_SLEE_RES,
	  M2_HOSTILE | M2_ELF },
	{ "human mummy", S_MUMMY, 6, 12, 4, 30, -5, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS, M2_HOSTILE },
	{ "ettin mummy", S_MUMMY, 7, 12, 4, 30, -6, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS | M1_BIG,
	  M2_HOSTILE | M2_STRONG },
	{ "giant mummy", S_MUMMY, 8, 14, 3, 30, -7, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 75, 750, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS | M1_BIG | M1_JEWELS,
	  M2_HOSTILE | M2_GIANT | M2_STRONG },
/*	Nymphs	*/
	{ "wood nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_TPORT | M1_COLLECT | M1_FEM, M2_HOSTILE },
	{ "water nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_TPORT | M1_COLLECT | M1_FEM | M1_SWIM,
	  M2_HOSTILE },
	{ "mountain nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_TPORT | M1_COLLECT | M1_FEM, M2_HOSTILE },
/*	Ogres	*/
	{ "ogre", S_OGRE, 5, 10, 5, 0, -3, (G_SGROUP | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 5 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 500, 0, MS_GRUNT,
	  M1_BIG | M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_STRONG },
	{ "ogre lord", S_OGRE, 7, 12, 3, 30, -5, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_GRUNT,
	  M1_BIG | M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT | M1_LORD,
	  M2_STRONG },
	{ "ogre king", S_OGRE, 7, 14, 4, 60, -7, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 3, 5 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 750, 0, MS_GRUNT,
	  M1_BIG | M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT | M1_PRINCE,
	  M2_STRONG },
/*	Puddings */
	{ "gray ooze", S_PUDDING, 3, 1, 8, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_RUST, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_NOEYES | M1_NOHANDS | M1_POIS_RES, 
	  M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE | M2_AMORPHOUS },
	{ "brown pudding", S_PUDDING, 5, 3, 8, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DCAY, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_NOEYES | M1_NOHANDS | M1_POIS_RES |
	  M1_COLD_RES | M1_ELEC_RES,
	  M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE | M2_AMORPHOUS },
	{ "black pudding", S_PUDDING, 10, 6, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_RUST, 3, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_NOEYES | M1_NOHANDS | M1_POIS_RES |
	  M1_COLD_RES | M1_ELEC_RES,
	  M2_HOSTILE | M2_NOLIMBS | M2_OMNIVORE | M2_AMORPHOUS },
/*	Quantum Mechanics	*/
	{ "quantum mechanic", S_QUANTMECH, 7, 12, 3, 10, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_TLPT, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, M1_ANIMAL | M1_HUMANOID | M1_POIS, M2_HOSTILE },
	{ "mad scientist", S_QUANTMECH, 8, 12, 2, 20, 0, (G_GENO | 2),
	  { { AT_WEAP, AD_SLEE, 1, 8 }, { AT_CLAW, AD_DREN, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 200, 0, MS_SILENT, M1_HUMANOID | M1_POIS | M1_COLLECT,
	  M2_HOSTILE | M2_HUMAN },
/*	Rust Monster	*/
	{ "rust monster", S_RUSTMONST, 5, 18, 2, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_RUST, 0, 0 }, { AT_TUCH, AD_RUST, 0, 0 }, NO_ATTK,
	    NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_SWIM | M1_ANIMAL | M1_NOHANDS, M2_HOSTILE },
/*	Snakes	*/
	{ "garter snake", S_SNAKE, 1, 8, 8, 0, 0, (G_LGROUP | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 60, 0, MS_HISS,
	  M1_VSMALL | M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_EGGS, M2_CONCEAL |
	  M2_NOLIMBS | M2_CARNIVORE },
	{ "snake", S_SNAKE, 4, 15, 3, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 80, 0, MS_HISS, M1_VSMALL | M1_SWIM | M1_ANIMAL | M1_NOHANDS |
	  M1_EGGS | M1_POIS | M1_POIS_RES, M2_HOSTILE | M2_CONCEAL |
	  M2_NOLIMBS | M2_CARNIVORE },
	{ "pit viper", S_SNAKE, 6, 15, 2, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, { AT_BITE, AD_DRST, 1, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 5, 60, 0, MS_HISS, M1_VSMALL |
	  M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_EGGS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CONCEAL | M2_NOLIMBS | M2_CARNIVORE },
	{ "cobra", S_SNAKE, 6, 18, 2, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 2, 4 }, { AT_SPIT, AD_BLND, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 15, 100, 0, MS_HISS, M1_VSMALL |
	  M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_EGGS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CONCEAL | M2_NOLIMBS | M2_CARNIVORE },
	{ "python", S_SNAKE, 6, 3, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, { AT_HUGS, AD_WRAP, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 15, 100, 0, MS_HISS, M1_BIG |
	  M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_EGGS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_NOLIMBS | M2_CARNIVORE },
	{ "water moccasin", S_SNAKE, 4, 15, 3, 0, 0,
	  (G_GENO | G_NOGEN | G_LGROUP),
	  { { AT_BITE, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_HISS, M1_VSMALL | M1_SWIM | M1_ANIMAL | M1_NOHANDS |
	  M1_EGGS | M1_POIS | M1_POIS_RES, M2_HOSTILE | M2_CONCEAL |
	  M2_NOLIMBS | M2_CARNIVORE },
/*	Trolls	*/
	{ "troll", S_TROLL, 7, 12, 4, 0, -3, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 4, 2 }, { AT_CLAW, AD_PHYS, 4, 2 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_GRUNT, M1_BIG | M1_HUMANOID | M1_REGEN | M1_STALK,
	  M2_STRONG | M2_CARNIVORE | M2_HOSTILE },
	{ "ice troll", S_TROLL, 9, 10, 2, 20, -3, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_COLD, 2, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 300, 0, MS_GRUNT,
	  M1_BIG | M1_HUMANOID | M1_COLD_RES | M1_REGEN | M1_STALK,
	  M2_STRONG | M2_CARNIVORE | M2_HOSTILE },
	{ "rock troll", S_TROLL, 9, 12, 0, 0, -3, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 300, 0, MS_GRUNT,
	  M1_BIG | M1_HUMANOID | M1_REGEN | M1_STALK | M1_COLLECT,
	  M2_STRONG | M2_CARNIVORE | M2_HOSTILE },
	{ "water troll", S_TROLL, 11, 14, 4, 40, -3, (G_NOGEN | G_GENO),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_GRUNT,
	  M1_BIG | M1_SWIM | M1_HUMANOID | M1_REGEN | M1_STALK,
	  M2_STRONG | M2_CARNIVORE | M2_HOSTILE },
#ifdef TOLKIEN
	{ "Olog-hai", S_TROLL, 13, 12, -4, 0, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_GRUNT,
	  M1_BIG | M1_HUMANOID | M1_REGEN | M1_STALK | M1_COLLECT,
	  M2_STRONG | M2_CARNIVORE | M2_HOSTILE },
#endif
/*	Umber Hulk	*/
	{ "umber hulk", S_UMBER, 9, 6, 2, 25, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 2, 5 }, { AT_GAZE, AD_CONF, 0, 0 }, NO_ATTK },
	  50, 500, 0, MS_SILENT, M1_BIG, M2_STRONG | M2_TUNNEL | M2_CARNIVORE },
/*	Vampires	*/
	{ "vampire", S_VAMPIRE, 10, 12, 1, 25, -8, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRLI, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 400, 0, MS_VAMPIRE,
	  M1_FLY | M1_HUMANOID | M1_UNDEAD | M1_POIS | M1_REGEN |
	  M1_STALK, M2_HOSTILE | M2_STRONG | M2_NASTY },
	{ "vampire lord", S_VAMPIRE, 12, 14, 0, 50, -9, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 8 }, { AT_BITE, AD_DRLI, 1, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 400, 0, MS_VAMPIRE,
	  M1_FLY | M1_HUMANOID | M1_UNDEAD | M1_POIS | M1_REGEN |
	  M1_STALK | M1_LORD, M2_HOSTILE | M2_STRONG | M2_NASTY },
	{ "Vlad the Impaler", S_VAMPIRE, 14, 18, -3, 80, -10,
	  (G_NOGEN | G_NOCORPSE | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRLI, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 400, PL_NSIZ, MS_VAMPIRE,
	  M1_NOPOLY | M1_FLY | M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_REGEN | M1_STALK | M1_PRINCE, 
	  M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY },
/*	Wraiths 	*/
	{ "barrow wight", S_WRAITH, 3, 12, 5, 5, -3, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_DRLI, 0, 0 }, NO_ATTK, NO_ATTK }, 30, 0, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS_RES | M1_STALK | M1_COLLECT, 
	  M2_HOSTILE },
	{ "wraith", S_WRAITH, 6, 12, 4, 15, -6, (G_GENO | 2),
	  { { AT_TUCH, AD_DRLI, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT,
	  M1_FLY | M1_HUMANOID | M1_UNDEAD | M1_POIS_RES | M1_STALK, 
	  M2_HOSTILE },
#ifdef TOLKIEN
	{ "Nazgul", S_WRAITH, 13, 12, 0, 25, -17, (G_GENO | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_DRLI, 1, 4 }, { AT_BREA, AD_SLEE, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 0, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS_RES | M1_STALK | M1_COLLECT, 
	  M2_STRONG | M2_HOSTILE },
#endif
/*	Xorn	*/
	{ "xorn", S_XORN, 8, 9,-2, 20, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 4, 6 },
	    NO_ATTK }, 70, 700, 0, MS_SILENT,
	  M1_BIG | M1_WALLWALK | M1_FIRE_RES | M1_COLD_RES | M1_STON_RES,
	  M2_HOSTILE | M2_STRONG | M2_THICK_HIDE },
/*	Yeti	*/
	{ "yeti", S_YETI, 5, 15, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_GROWL, M1_BIG | M1_ANIMAL | M1_HUMANOID | M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
/*	Zombies 	*/
	{ "kobold zombie", S_ZOMBIE, 0, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_POIS_RES | M1_STALK, M2_HOSTILE },
	{ "gnome zombie", S_ZOMBIE, 1, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 5 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_HUMANOID | M1_UNDEAD | M1_POIS |
	  M1_POIS_RES | M1_STALK, M2_HOSTILE },
	{ "orc zombie", S_ZOMBIE, 2, 6, 9, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_SILENT, M1_HUMANOID | M1_UNDEAD | M1_POIS_RES |
	  M1_STALK | M1_GREEDY | M1_JEWELS, M2_HOSTILE | M2_ORC },
	{ "elf zombie", S_ZOMBIE, 3, 6, 9, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 7 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_SILENT, M1_HUMANOID | M1_UNDEAD | M1_POIS_RES |
	  M1_STALK | M1_SLEE_RES, M2_HOSTILE | M2_ELF },
	{ "human zombie", S_ZOMBIE, 4, 6, 8, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT,
	  M1_HUMANOID | M1_UNDEAD | M1_POIS_RES | M1_STALK, M2_HOSTILE },
	{ "ettin zombie", S_ZOMBIE, 6, 8, 6, 0, -4, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 10 }, { AT_CLAW, AD_PHYS, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_UNDEAD | M1_POIS_RES | M1_STALK,
	  M2_HOSTILE | M2_STRONG },
	{ "giant zombie", S_ZOMBIE, 8, 8, 6, 0, -4, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 75, 750, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_UNDEAD | M1_POIS_RES | M1_STALK |
	  M1_JEWELS, M2_HOSTILE | M2_GIANT | M2_STRONG },
/*	Golems	*/
#ifdef GOLEMS
	{ "straw golem", S_GOLEM, 3, 12, 10, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 10, 0, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_POIS_RES, M2_HOSTILE },
	{ "rope golem", S_GOLEM, 4, 9, 8, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_HUGS, AD_PHYS, 6, 1 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 20, 0, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_POIS_RES, M2_HOSTILE },
	{ "leather golem", S_GOLEM, 6, 6, 6, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 0, 0, MS_SILENT,
	  M1_BIG | M1_HUMANOID | M1_POIS_RES, M2_HOSTILE },
	{ "wood golem", S_GOLEM, 7, 3, 4, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 0, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_POIS_RES,
	  M2_HOSTILE | M2_THICK_HIDE },
	{ "flesh golem", S_GOLEM, 9, 8, 9, 30, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 600, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_POIS_RES |
	  M1_FIRE_RES | M1_COLD_RES | M1_ELEC_RES, M2_HOSTILE | M2_STRONG },
	{ "clay golem", S_GOLEM, 11, 7, 7, 40, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 0, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_THICK_HIDE },
	{ "stone golem", S_GOLEM, 14, 6, 5, 50, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  90, 0, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_POIS_RES | M1_STON_RES,
	  M2_HOSTILE | M2_STRONG | M2_THICK_HIDE },
	{ "iron golem", S_GOLEM, 18, 6, 3, 60, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_BREA, AD_DRST, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 0, 0, MS_SILENT, M1_BIG | M1_HUMANOID | M1_POIS |
	  M1_FIRE_RES | M1_COLD_RES | M1_ELEC_RES | M1_COLLECT,
	  M2_HOSTILE | M2_STRONG | M2_THICK_HIDE },
#endif /* GOLEMS */
/*	Humans		*/
	{ "human", S_HUMAN, 0, 12, 10, 0, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_PEACEFUL | M2_STRONG }, /* for corpses */
	{ "wererat", S_HUMAN, 2, 12, 7, 10, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SILENT, M1_NOPOLY | M1_HUMANOID | M1_WERE | M1_POIS |
	  M1_REGEN | M1_COLLECT, M2_HOSTILE | M2_HUMAN },
	{ "werejackal", S_HUMAN, 2, 12, 7, 10, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_BARK, M1_NOPOLY | M1_HUMANOID | M1_WERE | M1_POIS |
	  M1_REGEN | M1_COLLECT, M2_HOSTILE | M2_HUMAN },
	{ "werewolf", S_HUMAN, 5, 12, 6, 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_BARK, M1_NOPOLY | M1_HUMANOID | M1_WERE | M1_POIS |
	  M1_REGEN | M1_COLLECT, M2_HOSTILE | M2_HUMAN },
#ifdef TOLKIEN
	{ "Woodland-elf", S_HUMAN, 4, 12, 5, 10, 5, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, M1_HUMANOID | M1_COLLECT | M1_SLEE_RES,
	  M2_ELF },
	{ "Green-elf", S_HUMAN, 5, 12, 5, 10, 6, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, M1_HUMANOID | M1_COLLECT | M1_SLEE_RES,
	  M2_ELF },
	{ "Grey-elf", S_HUMAN, 6, 12, 5, 10, 7, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, M1_HUMANOID | M1_COLLECT | M1_SLEE_RES,
	  M2_ELF },
#endif
	{ "elf-lord", S_HUMAN, 8, 12, 5, 20, 9, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, M1_HUMANOID | M1_LORD | M1_COLLECT |
	  M1_SLEE_RES, M2_ELF | M2_STRONG },
	{ "Elvenking", S_HUMAN, 9, 12, 5, 25, 10, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4},
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, M1_HUMANOID | M1_PRINCE | M1_COLLECT |
	  M1_SLEE_RES, M2_ELF | M2_STRONG },
	{ "nurse", S_HUMAN, 11, 6, 0, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_HEAL, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_NURSE, M1_NOPOLY | M1_HUMANOID | M1_POIS_RES,
	  M2_HUMAN | M2_HOSTILE },
	{ "shopkeeper", S_HUMAN, 12, 18, 0, 50, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 4 }, { AT_WEAP, AD_PHYS, 4, 4 }, NO_ATTK,
	    NO_ATTK, NO_ATTK }, 45, 400, sizeof(struct eshk), MS_SELL,
	  M1_NOPOLY | M1_HUMANOID | M1_MAGIC | M1_COLLECT,
	  M2_HUMAN | M2_PEACEFUL | M2_STRONG },
	{ "guard", S_HUMAN, 12, 12, -1, 40, 10, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, sizeof(struct egd), MS_GUARD,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_PEACEFUL | M2_STRONG },
#if defined(ALTARS) && defined(THEOLOGY)
	{ "temple priest", S_HUMAN, 12, 12, 0, 50, 1, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 1, 4 },
	    { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK, NO_ATTK },
	  45, 400, sizeof(struct epri), MS_PRIEST, 
	  M1_NOPOLY | M1_HUMANOID | M1_ELEC_RES | M1_COLLECT, 
	  M2_HUMAN | M2_PEACEFUL },
	{ "temple priestess", S_HUMAN, 12, 12, 0, 50, 1, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 1, 4 },
	    { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK, NO_ATTK },
	  45, 400, sizeof(struct epri), MS_PRIEST,
	  M1_NOPOLY | M1_HUMANOID | M1_ELEC_RES | M1_COLLECT | M1_FEM, 
	  M2_HUMAN | M2_PEACEFUL },
#endif
#ifdef ARMY
	{ "unarmored soldier", S_HUMAN, 6, 4, 10, 0, -2, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SOLDIER,
	  M1_NOPOLY | M1_HUMANOID | M1_STALK | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_HOSTILE | M2_STRONG },
	{ "soldier", S_HUMAN, 6, 4, 3, 0, -2, (G_SGROUP | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SOLDIER,
	  M1_NOPOLY | M1_HUMANOID | M1_STALK | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_HOSTILE | M2_STRONG },
	{ "sergeant", S_HUMAN, 8, 4, 0, 5, -3, (G_SGROUP | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SOLDIER,
	  M1_NOPOLY | M1_HUMANOID | M1_STALK | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_HOSTILE | M2_STRONG },
	{ "lieutenant", S_HUMAN, 10, 4, -2, 15, -4, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_WEAP, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, 0, MS_SOLDIER,
	  M1_NOPOLY | M1_HUMANOID | M1_STALK | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_HOSTILE | M2_STRONG },
	{ "captain", S_HUMAN, 12, 4, -3, 15, -5, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 4, 4 }, { AT_WEAP, AD_PHYS, 4, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, 0, MS_SOLDIER,
	  M1_NOPOLY | M1_HUMANOID | M1_STALK | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_HOSTILE | M2_STRONG },
#endif
	{ "Wizard of Yendor", S_HUMAN, 30, 12, -8, 100, -20, G_NOGEN,
	  { { AT_CLAW, AD_SAMU, 2, 12 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_BITE, AD_CUSS, 0, 0 }, NO_ATTK, NO_ATTK }, 45, 400, PL_NSIZ,
	  MS_CUSS, M1_NOPOLY | M1_FLY | M1_HUMANOID | M1_POIS_RES |
	  M1_FIRE_RES | M1_REGEN | M1_SEE_INVIS | M1_TPORT |
	  M1_TPORT_CONTROL | M1_MAGIC,
	  M2_HUMAN | M2_PNAME | M2_HOSTILE | M2_STRONG | M2_NASTY },
#ifdef MEDUSA
	{ "Medusa", S_HUMAN, 20, 12, 2, 50, -15, G_NOGEN | G_UNIQ,
	  { { AT_CLAW, AD_PHYS, 1, 8 }, { AT_GAZE, AD_STON, 0, 0 },
	    { AT_BITE, AD_DRST, 1, 6 }, { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK },
	  45, 400, PL_NSIZ, MS_HISS,
	  M1_NOPOLY | M1_BIG | M1_HUMANOID | M1_POIS | M1_POIS_RES |
	  M1_STON_RES | M1_FEM, M2_HOSTILE | M2_STRONG | M2_PNAME },
#endif
#ifdef ORACLE
	{ "oracle", S_HUMAN, 12, 0, 0, 50, 0, G_NOGEN | G_UNIQ,
	  { { AT_NONE, AD_MAGM, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_ORACLE, M1_NOPOLY | M1_HUMANOID | M1_FEM,
	  M2_HUMAN | M2_PEACEFUL },
#endif
#ifdef CHARON
	{ "Charon", S_HUMAN, 76, 18, -5, 120, 0,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_TUCH, AD_PLYS, 1, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, PL_NSIZ, MS_FERRY,
	  M1_NOPOLY | M1_SEE_INVIS | M1_HUMANOID | M1_POIS_RES | M1_FIRE_RES |
	  M1_COLLECT, M2_HUMAN | M2_PEACEFUL },
#endif
/*	Ghost		*/
	{ "ghost", S_GHOST, 10, 3, -5, 50, -5, (G_NOCORPSE | G_NOGEN),
	  { { AT_TUCH, AD_PHYS, 1, 1 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 0, PL_NSIZ, MS_SILENT, M1_NOPOLY | M1_FLY | M1_WALLWALK |
	  M1_HUMANOID | M1_UNDEAD | M1_STALK | M1_POIS_RES, M2_HOSTILE },
/*	(major) Demons	*/
	{ "water demon", S_DEMON, 8, 12,-4, 30, -7, (G_NOCORPSE | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_SILENT, M1_SWIM | M1_POIS | M1_FIRE_RES |
	  M1_STALK | M1_COLLECT, M2_DEMON | M2_HOSTILE | M2_NASTY },
#ifndef HARD /* generic type */
	{ "demon", S_DEMON, 10, 12,-4, 30, -7, (G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_JEER, M1_POIS | M1_FIRE_RES | M1_STALK | M1_COLLECT,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
#else	/* used in hell for bigger, badder demons! */
	/* standard demons & devils */
	{ "horned devil", S_DEMON, 6, 9, -5, 50, 11, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 3 }, { AT_STNG, AD_PHYS, 1, 3 }, NO_ATTK },
	  45, 450, 0, MS_SILENT, M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY | M2_THICK_HIDE },
#ifdef SEDUCE
	{ "succubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_BITE, AD_SSEX, 0, 0 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK }, 45, 450, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES | M1_STALK | M1_FEM,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "incubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_BITE, AD_SSEX, 0, 0 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK }, 45, 450, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
#else
	{ "succubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_DRLI, 2, 6 }, NO_ATTK }, 45, 450, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES | M1_STALK | M1_FEM,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "incubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_DRLI, 2, 6 }, NO_ATTK }, 45, 450, 0, MS_SEDUCE,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
#endif
	{ "erinyes", S_DEMON, 7, 12, 2, 30, 10,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_WEAP, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_SILENT, M1_HUMANOID | M1_POIS | M1_FIRE_RES |
	  M1_STALK | M1_COLLECT | M1_FEM,
	  M2_DEMON | M2_HOSTILE | M2_STRONG | M2_NASTY },
	{ "marilith", S_DEMON, 7, 12, -6, 80, -12, (G_HELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, }, 45, 450, 0, MS_SILENT, M1_HUMANOID |
	  M1_SEE_INVIS | M1_POIS | M1_FIRE_RES | M1_STALK | M1_COLLECT |
	  M1_FEM, M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "barbed devil", S_DEMON, 8, 12, 0, 35, 8,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_STNG, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_SILENT, M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY | M2_THICK_HIDE },
	{ "vrock", S_DEMON, 8, 12, 0, 50, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_CLAW, AD_PHYS, 1, 8 }, { AT_CLAW, AD_PHYS, 1, 8 },
	    { AT_BITE, AD_PHYS, 1, 6 }, },
	  45, 450, 0, MS_SILENT, M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "hezrou", S_DEMON, 9, 6, -2, 55, -10,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK }, 45, 450, 0,
	  MS_SILENT, M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "bone devil", S_DEMON, 9, 15, -1, 40, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_STNG, AD_DRST, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 450, 0, MS_SILENT,
	  M1_POIS | M1_FIRE_RES | M1_STALK | M1_COLLECT,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "nalfeshnee", S_DEMON, 11, 9, -1, 65, -11, (G_HELL | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK },
	  45, 450, 0, MS_SILENT, M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_STALK,
	  M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "ice devil", S_DEMON, 11, 6, -4, 55, -12, (G_HELL | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_STNG, AD_COLD, 3, 4 }, NO_ATTK },
	  45, 450, 0, MS_SILENT, M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_COLD_RES | M1_STALK, M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "pit fiend", S_DEMON, 13, 6, -3, 65, -13, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 4, 2 }, { AT_WEAP, AD_PHYS, 4, 2 },
	    { AT_HUGS, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK }, 45, 450, 0,
	  MS_GROWL, M1_SEE_INVIS | M1_POIS | M1_FIRE_RES | M1_STALK |
	  M1_COLLECT, M2_DEMON | M2_HOSTILE | M2_NASTY },
	{ "balrog", S_DEMON, 16, 5, -2, 75, -14, (G_HELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 8, 4 }, { AT_WEAP, AD_PHYS, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 450, 0, MS_SILENT,
	  M1_FLY | M1_BIG | M1_SEE_INVIS | M1_COLLECT | M1_STALK | M1_POIS |
	  M1_FIRE_RES, M2_DEMON | M2_HOSTILE | M2_STRONG | M2_NASTY },
	/* Named demon lords & princes plus Arch-Devils */
	{ "Juiblex", S_DEMON, 50, 3, -7, 65, -15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_ENGL, AD_DISE, 4, 10 }, { AT_SPIT, AD_ACID, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, PL_NSIZ, MS_GURGLE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_NOHANDS | M1_POIS |
	  M1_FIRE_RES | M1_STALK | M1_LORD,
	  M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_AMORPHOUS },
	{ "Yeenoghu", S_DEMON, 56, 18, -5, 80, -15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 3, 6 }, { AT_WEAP, AD_CONF, 2, 8 },
	    { AT_WEAP, AD_PLYS, 1, 6 }, { AT_MAGC, AD_MAGM, 2, 6 }, NO_ATTK },
	  50, 500, PL_NSIZ, MS_ORC, M1_NOPOLY | M1_FLY | M1_SEE_INVIS |
	  M1_POIS | M1_FIRE_RES | M1_STALK | M1_COLLECT | M1_LORD,
	  M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY },
	{ "Orcus", S_DEMON, 66, 9, -6, 85, -20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 8, 6 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_STNG, AD_DRST, 2, 4 }, }, 50, 500, PL_NSIZ, MS_ORC,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_STALK | M1_COLLECT | M1_PRINCE,
	  M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY },
	{ "Geryon", S_DEMON, 72, 3, -3, 75, 15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 3, 6 }, { AT_CLAW, AD_PHYS, 3, 6 },
	    { AT_STNG, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK }, 50, 500, PL_NSIZ,
	  MS_JEER, M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_STALK | M1_PRINCE, M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY },
	{ "Dispater", S_DEMON, 78, 15, -2, 80, 15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 6 }, { AT_MAGC, AD_SPEL, 6, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, PL_NSIZ, MS_JEER,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_POIS |
	  M1_FIRE_RES | M1_STALK | M1_COLLECT | M1_PRINCE,
	  M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY },
	{ "Baalzebub", S_DEMON, 89, 9, -5, 85, 20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_BITE, AD_DRST, 2, 6 }, { AT_GAZE, AD_STUN, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, PL_NSIZ, MS_JEER,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_STALK | M1_PRINCE, M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY },
	{ "Asmodeus", S_DEMON, 105, 12, -7, 90, 20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, { AT_MAGC, AD_COLD, 6, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, PL_NSIZ, MS_JEER,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_POIS |
	  M1_FIRE_RES | M1_COLD_RES | M1_STALK | M1_PRINCE,
	  M2_DEMON | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY },
	{ "Demogorgon", S_DEMON, 106, 15, -8, 95, -20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 8, 6 }, { AT_STNG, AD_DRLI, 1, 4 },
	    { AT_CLAW, AD_DISE, 1, 6 }, { AT_CLAW, AD_DISE, 1, 6 },
	    NO_ATTK }, 50, 500, PL_NSIZ, MS_GROWL, M1_NOPOLY | M1_FLY |
	  M1_SEE_INVIS | M1_NOHANDS | M1_POIS | M1_FIRE_RES | M1_STALK |
	  M1_PRINCE, M2_DEMON | M2_HOSTILE | M2_PNAME | M2_NASTY },
#endif
#ifdef MAIL
	{ "mail daemon", S_DEMON, 56, 24, 10, 127, 0, (G_NOGEN | G_NOCORPSE),
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0,
	  MS_SILENT, M1_NOPOLY | M1_FLY | M1_SWIM | M1_SEE_INVIS |
	  M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_COLD_RES | M1_SLEE_RES |
	  M1_STALK, M2_PEACEFUL },
/* Neither rain nor sleet nor gloom of night shall stay this courier... */
#endif
	{ "djinni", S_DEMON, 7, 12, 4, 30, 0, (G_NOGEN | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_DJINNI,
	  M1_NOPOLY | M1_FLY | M1_POIS | M1_STALK | M1_COLLECT, 0 },
/*	eels		*/
	{ "giant eel", S_EEL, 5, 9, -1, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_TUCH, AD_WRAP, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 10, 250, 0, MS_SILENT,
	  M1_BIG | M1_VSMALL | M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_NOPOLY |
	  M1_EGGS, M2_HOSTILE | M2_NOLIMBS | M2_CARNIVORE },
	{ "electric eel", S_EEL, 7, 10, -3, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_ELEC, 4, 6 }, { AT_TUCH, AD_WRAP, 0, 0 },
	  NO_ATTK, NO_ATTK, NO_ATTK }, 10, 250, 0, MS_SILENT,
	  M1_BIG | M1_VSMALL | M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_NOPOLY |
	  M1_EGGS | M1_ELEC_RES, M2_HOSTILE | M2_NOLIMBS | M2_CARNIVORE },
/*	kraken	*/
	{ "kraken", S_EEL, 20, 3, 6, 0, -3, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_HUGS, AD_WRAP, 2, 6 }, { AT_BITE, AD_PHYS, 5, 4 }, NO_ATTK },
	  1, 10, 0, MS_SILENT,
	  M1_BIG | M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_NOPOLY,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE },
/*	chameleon	*/
	{ "chameleon", S_CHAMELEON, 6, 5, 6, 10, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 4, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, M1_VSMALL | M1_ANIMAL,
	  M2_HOSTILE | M2_CARNIVORE },

/*	character classes */
	{ "archeologist", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG | M2_TUNNEL | M2_NEEDPICK },
	{ "barbarian", S_HUMAN, 1, 10, 10, 1, -3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT |
	  M1_POIS_RES, M2_HUMAN | M2_STRONG },
	{ "caveman", S_HUMAN, 1, 10, 10, 0, 1, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 2, 4}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG | M2_CARNIVORE },
	{ "cavewoman", S_HUMAN, 1, 10, 10, 0, 1, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 2, 4}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_FEM,
	  M2_HUMAN | M2_STRONG | M2_CARNIVORE },
	/* Note: players who are elves still get normal carrying capacity,
	 * even though this is strictly speaking inconsistent.
	 */
	{ "elf", S_HUMAN, 1, 12, 10, 2, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 8}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT |
	  M1_SLEE_RES | M1_SEE_INVIS, M2_ELF | M2_STRONG },
	{ "healer", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT |
	  M1_POIS_RES, M2_HUMAN | M2_STRONG },
	{ "knight", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG },
	{ "priest", S_HUMAN, 1, 10, 10, 2, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG },
	{ "priestess", S_HUMAN, 1, 10, 10, 2, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_FEM,
	  M2_HUMAN | M2_STRONG },
	{ "rogue", S_HUMAN, 1, 10, 10, 1, -3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT |
	  M1_GREEDY, M2_HUMAN | M2_STRONG },
	{ "samurai", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 8}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG },
	{ "tourist", S_HUMAN, 1, 10, 10, 1, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG },
	{ "valkyrie", S_HUMAN, 1, 10, 10, 1, -1, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 8}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, M1_NOPOLY | M1_HUMANOID | M1_COLLECT | 
	  M1_COLD_RES | M1_FEM, M2_HUMAN | M2_STRONG },
	{ "wizard", S_HUMAN, 1, 10, 10, 3, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID,
	  M1_NOPOLY | M1_HUMANOID | M1_MAGIC | M1_COLLECT,
	  M2_HUMAN | M2_STRONG },

/*	ARRAY TERMINATOR	*/
	{ "", 0, 0, 0, 0, 0, 0, 0,
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, 0, 0, 0 }
};
#endif /* !SPLITMON_1 */
