/******************************************************
 *                                                    *
 *        nethack.r                                   *
 *                                                    *
 *        Resource file for NetHack 3.0g application  *
 *                                                    *
 *        Copyright 1989 by Johnny Lee                *
 *        NetHack may be freely redistributed.        *
 *	  See license for details.		      *
 *                                                    *
 ******************************************************/

#include 	"Types.r"
#include	"SysTypes.r"

resource 'ICN#' (129, purgeable) {
	{ /* array: 2 elements */
		/* [1] */
		$"4B BA 91 A8 6A 12 AA 28 5B 13 BA 30 4A 12 AA 28"
		$"4B 92 A9 A8 00 00 00 10 08 00 00 10 09 81 80 10"
		$"09 83 C0 10 09 83 E0 10 08 C3 C0 10 08 C1 80 10"
		$"08 63 DF 90 08 67 FF 90 08 3F FF 90 08 1B DF 90"
		$"08 03 DF 90 08 03 DF 90 08 03 CF 10 08 03 C6 10"
		$"08 00 00 10 08 E2 57 10 09 05 54 10 08 E7 56 10"
		$"08 15 54 10 08 E5 27 10 04 00 00 20 03 FF FF C0",
		/* [2] */
		$"7F FF FF FF 7F FF FF FF 7F FF FF FF 7F FF FF FF"
		$"7F FF FF FF 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 07 FF FF E0 03 FF FF C0"
	}
};

resource 'ICN#' (128, purgeable) {
	{ /* array: 2 elements */
		/* [1] */
		$"00 00 00 00 00 00 00 00 4B BA 91 A8 6A 12 AA 30"
		$"5B 13 BA 28 4A 12 AA 28 4B 92 A9 A8 00 00 00 00"
		$"00 00 00 00 30 00 00 00 38 01 80 00 1C 03 C0 00"
		$"0E 03 E7 80 07 03 CF 80 03 E1 88 80 01 C3 C8 80"
		$"01 E7 E8 80 01 3F F9 80 00 1B DB 80 00 03 CE 80"
		$"00 03 CC 80 00 03 C8 80 00 03 E4 80 00 03 F3 80"
		$"00 03 B8 00 00 07 1C 00 00 1E 0C 00 00 1C 0C 00"
		$"00 18 0E 00 00 1C 0F",
		/* [2] */
		$"7F FF FF FE FF FF FF FF FF FF FF FD FF FF FF FD"
		$"FF FF FF FD FF FF FF FF FF FF FF FD FF FF FF FF"
		$"FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF"
		$"FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF"
		$"FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF"
		$"FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF"
		$"FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF"
		$"FF FF FF 87 FF FF FF D7 FF FF FF 93 FF FF FF FF"
	}
};

resource 'ICN#' (130, purgeable) {
	{ /* array: 2 elements */
		/* [1] */
		$"4B BA 91 A8 6A 12 AA 28 5B 13 BA 30 4A 12 AA 28"
		$"4B 92 A9 A8 00 00 00 00 04 00 00 20 09 81 80 10"
		$"09 83 C0 10 09 83 E0 10 08 C3 C0 10 08 C1 80 10"
		$"08 63 DF 90 08 67 FF 90 08 3F FF 90 08 1B DF 90"
		$"08 03 DF 90 08 03 CF 10 08 03 C6 10 08 03 C0 10"
		$"08 00 00 10 08 00 00 10 04 00 00 20 00 00 00 00"
		$"74 59 09 9C 42 95 15 50 61 19 15 98 42 91 15 50"
		$"74 51 C9 5C",
		/* [2] */
		$"7F FF FF FE 7F FF FF FE 7F FF FF FE 7F FF FF FE"
		$"7F FF FF FE 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 0F FF FF F0"
		$"0F FF FF F0 0F FF FF F0 0F FF FF F0 FF FF FF FE"
		$"FF FF FF FE FF FF FF FE FF FF FF FE FF FF FF FE"
		$"FF FF FF FE FF FF FF FE"
	}
};

resource 'ICN#' (131, purgeable) {
	{ /* array: 2 elements */
		/* [1] */
		$"00 00 00 00 4B BA 91 A8 6A 12 AA 28 5B 13 BA 30"
		$"4A 12 AA 28 4B 92 A9 A8 00 00 00 00 0F FF C0 00"
		$"0F FF C0 00 01 80 00 00 3F FF FC 00 3F FF FC 00"
		$"00 00 C0 00 00 3F FF F0 00 3F FF F0 00 18 00 C0"
		$"0F FE 00 C0 0F FE 00 C0 01 80 00 C0 03 FF FF FE"
		$"03 FF FF FE 00 00 0C 00 00 00 0C 00 00 00 00 00"
		$"02 3A BA 00 02 22 A2 00 02 32 B2 00 02 22 A2 00"
		$"03 B9 3B 80",
		/* [2] */
		$"FF FF FF FC FF FF FF FC FF FF FF FC FF FF FF FC"
		$"FF FF FF FC FF FF FF FC FF FF FF FC 1F FF E0 00"
		$"1F FF E0 00 7F FF FE 00 7F FF FE 00 7F FF FE 00"
		$"7F FF FF F8 00 7F FF F8 00 7F FF F8 1F FF FF E0"
		$"1F FF FF E0 1F FF FF E0 0F FF FF FF 0F FF FF FF"
		$"0F FF FF FF 0F FF FF FC 0F FF FF FC 0F FF FF FC"
		$"0F FF FF FC 0F FF FF FC 0F FF FF FC 0F FF FF FC"
		$"0F FF FF FC 0F FF FF FC"
	}
};

resource 'ICN#' (132, purgeable) {
	{ /* array: 2 elements */
		/* [1] */
		$"00 00 00 00 4B BA 91 A8 6A 12 AA 28 5B 13 BA 30"
		$"4A 12 AA 28 4B 92 A9 A8 00 00 00 00 00 C0 03 00"
		$"01 4F F2 80 02 30 0C 40 01 A0 05 80 00 40 02 00"
		$"00 46 62 00 00 46 62 00 00 40 02 00 00 60 06 00"
		$"00 21 84 00 00 50 0A 00 01 9B D9 80 02 28 14 40"
		$"02 4B D2 40 01 44 22 80 00 83 C1 00 00 00 00 00"
		$"0E 32 5C E0 09 4B 51 00 0E 4A D8 C0 09 4A 50 20"
		$"0E 32 5D C0",
		/* [2] */
		$"FF FF FF FC FF FF FF FC FF FF FF FC FF FF FF FC"
		$"FF FF FF FC FF FF FF FC FF FF FF FC 01 FF FF 80"
		$"03 FF FF C0 07 FF FF E0 07 FF FF E0 03 FF FF C0"
		$"00 FF FF 00 00 FF FF 00 00 FF FF 00 00 FF FF 00"
		$"00 FF FF 00 01 FF FF 80 03 FF FF C0 07 FF FF E0"
		$"07 FF FF E0 07 FF FF E0 07 FF FF E0 FF FF FF FF"
		$"FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF"
		$"FF FF FF FF FF FF FF FF"
	}
};

resource 'BNDL' (128, "NetHack for Mac", purgeable) {
	'nh30',
	0,
	{ /* array TypeArray: 2 elements */
		/* [1] */
		'ICN#',
		{ /* array IDArray: 5 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129,
			/* [3] */
			2, 130,
			/* [4] */
			3, 131,
			/* [5] */
			4, 132
		},
		/* [2] */
		'FREF',
		{ /* array IDArray: 5 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129,
			/* [3] */
			2, 130,
			/* [4] */
			3, 131,
			/* [5] */
			4, 132
		}
	}
};

resource 'FREF' (128, "Application", purgeable) {
	'APPL',
	0,
	""
};

resource 'FREF' (129, "Save Char File", purgeable) {
	'SAVE',
	1,
	""
};

resource 'FREF' (130, "Explore file", purgeable) {
	'XPLR',
	2,
	""
};

resource 'FREF' (131, "Level Temp File", purgeable) {
	'LEVL',
	3,
	""
};

resource 'FREF' (132, "Bones File") {
	'BONE',
	4,
	""
};

resource 'DLOG' (128, "FindFile") {
	{40, 80, 100, 300},
	dBoxProc,
	invisible,
	noGoAway,
	0x0,
	128,
	"FindFile"
};

resource 'DLOG' (129, "About NetHackI") {
	{63, 10, 263, 360},
	dBoxProc,
	invisible,
	noGoAway,
	0x0,
	129,
	""
};

resource 'DITL' (128) {
	{ /* array DITLarray: 1 elements */
		/* [1] */
		{4, 8, 80, 212},
		StaticText {
			disabled,
			"Please locate^0 file^1 ^2\nor press Cance"
			"l to abort."
		}
	}
};

resource 'DITL' (129) {
	{ /* array DITLarray: 8 elements */
		/* [1] */
		{155, 60, 175, 120},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{155, 184, 175, 274},
		Button {
			enabled,
			"More InfoI"
		},
		/* [3] */
		{10, 28, 26, 310},
		Picture {
			enabled,
			100
		},
		/* [4] */
		{68, 109, 86, 225},
		StaticText {
			enabled,
			"See license for details."
		},
		/* [5] */
		{36, 64, 52, 291},
		StaticText {
			enabled,
			"Copyright 1985, 1986, 1987, 1988, 1989."
		},
		/* [6] */
		{51, 37, 69, 323},
		StaticText {
			enabled,
			"By Stichting Mathematisch Centrum and Mi"
			"ke Stephenson."
		},
		/* [7] */
		{85, 109, 140, 333},
		StaticText {
			disabled,
			"Bug reports - email t-jlee@microsoft.UUC"
			"P or\nJohnny Lee\n388 Cummer Ave.\nWillowda"
			"le, Ont. CANADA M2M 2G2"
		},
		/* [8] */
		{97, 16, 116, 110},
		StaticText {
			enabled,
			"Macintosh port by:"
		}
	}
};

data 'HDTA' (201, "Apple menu") {
	$"3F 00"                                          /* ?. */
};

data 'HDTA' (202, "File menu") {
	$"4F 76 00 12 10 00 53 00 51"                     /* Ov....S.Q */
};

data 'HDTA' (204, "Inventory Menu") {
	$"69 70 64 44 2C 40 2F 43"                        /* ipdD,@/C */
};

data 'HDTA' (205, "Actions menu") {
	$"61 65 71 72 74 7A 5A"                           /* aeqrtzZ */
};

data 'HDTA' (206, "Preparations menu") {
	$"77 50 52 54 57 29 5B 3D 5C 28"                  /* wPRTW)[=\( */
};

data 'HDTA' (207, "Movement menu") {
	$"6F 63 04 73 3C 3E 14 2E 45"                     /* oc.s<>..E */
};

data 'HDTA' (203, "Edit menu") {
	$"00 00 00 00 00 00"                              /* ...... */
};

data 'HDTA' (208, "Extended Commands") {
	$"63 64 66 6A 6C 6D 6E 6F 70 72 73 74 75 77"      /* cdfjlmnoprstuw */
};

data 'HDTA' (102, "graphics") {
	$"20 BA CD C9 BB C8 BC CE CA CB B9 CC B3 C4 5C 2F"/*  :MI;H<NJK9L3D\/ */
	$"EF FA B0 3C 3E 5E 22 7D 7B 23 5C 5F 3C 3E 23 23"/* ..0<>^"}{#\_<>## */
};

data 'HDTA' (103, "keymap") {
	$"2E 6C 00 00 00 68 00 6A 00 00 00 70 6B 6D 00 00"/* .l...h.j...pkm.. */
	$"00 69 62 6A 6E 68 6F 6C 79 00 6B 75 00 00 E3 E4"/* .ibjnholy.ku.... */
	$"E6 EA EC ED CE EF F2 F3 F4 F5 F7 8D B6 C4 C6 C2"/* ....N......^M6DFB */
	$"B5 F6 BF A8 A7 A0 E8 B7 00 00 68 6C 6A 6B"      /* 5.?(' .7..hljk */
};

data 'HDTA' (100) {
	$"00 00 00 02 00 00 00 09 06 4D 6F 6E 61 63 6F"   /* .......F.Monaco */
};

data 'nh30' (0) {
	$"27 4E 65 74 48 61 63 6B 20 56 65 72 73 69 6F 6E"/* 'NetHack Version */
	$"20 33 2E 30 67 20 66 6F 72 20 74 68 65 20 4D 61"/*  3.0g for the Ma */
	$"63 69 6E 74 6F 73 68 A8"                        /* cintosh( */
};

resource 'MENU' (102, "File") {
	102,
	textMenuProc,
	0x7FFFFF5F,
	enabled,
	"File",
	{ /* array: 9 elements */
		/* [1] */
		"Set options", noIcon, noKey, noMark, plain,
		/* [2] */
		"Version number", noIcon, noKey, noMark, plain,
		/* [3] */
		"Invert Screen", noIcon, noKey, noMark, plain,
		/* [4] */
		"Redraw screen", noIcon, noKey, noMark, plain,
		/* [5] */
		"Repeat last message", noIcon, noKey, noMark, plain,
		/* [6] */
		"-", noIcon, noKey, noMark, plain,
		/* [7] */
		"Save game", noIcon, noKey, noMark, plain,
		/* [8] */
		"-", noIcon, noKey, noMark, plain,
		/* [9] */
		"Quit", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (103, "Edit") {
	103,
	textMenuProc,
	0x7FFFFFFD,
	enabled,
	"Edit",
	{ /* array: 6 elements */
		/* [1] */
		"Undo", noIcon, "Z", noMark, plain,
		/* [2] */
		"-", noIcon, noKey, noMark, plain,
		/* [3] */
		"Cut", noIcon, "X", noMark, plain,
		/* [4] */
		"Copy", noIcon, "C", noMark, plain,
		/* [5] */
		"Paste", noIcon, "V", noMark, plain,
		/* [6] */
		"Clear", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (104, "Inventory") {
	104,
	textMenuProc,
	allEnabled,
	enabled,
	"Inventory",
	{ /* array: 8 elements */
		/* [1] */
		"Do inventory", noIcon, noKey, noMark, plain,
		/* [2] */
		"Pay bill", noIcon, noKey, noMark, plain,
		/* [3] */
		"Drop object", noIcon, noKey, noMark, plain,
		/* [4] */
		"Drop several objects", noIcon, noKey, noMark, plain,
		/* [5] */
		"Pick up object", noIcon, noKey, noMark, plain,
		/* [6] */
		"Toggle pickup", noIcon, noKey, noMark, plain,
		/* [7] */
		"Identify object", noIcon, noKey, noMark, plain,
		/* [8] */
		"Name monster", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (105, "Actions") {
	105,
	textMenuProc,
	allEnabled,
	enabled,
	"Action",
	{ /* array: 7 elements */
		/* [1] */
		"Apply/use object", noIcon, noKey, noMark, plain,
		/* [2] */
		"Eat object", noIcon, noKey, noMark, plain,
		/* [3] */
		"Quaff potion", noIcon, noKey, noMark, plain,
		/* [4] */
		"Read scroll/book", noIcon, noKey, noMark, plain,
		/* [5] */
		"Throw/shoot weapon", noIcon, noKey, noMark, plain,
		/* [6] */
		"Zap wand", noIcon, noKey, noMark, plain,
		/* [7] */
		"Cast spell", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (106, "Preparations") {
	106,
	textMenuProc,
	allEnabled,
	enabled,
	"Prep",
	{ /* array: 10 elements */
		/* [1] */
		"Wield weapon", noIcon, noKey, noMark, plain,
		/* [2] */
		"Put on ring", noIcon, noKey, noMark, plain,
		/* [3] */
		"Remove ring", noIcon, noKey, noMark, plain,
		/* [4] */
		"Remove armor", noIcon, noKey, noMark, plain,
		/* [5] */
		"Wear armor", noIcon, noKey, noMark, plain,
		/* [6] */
		"Current weapon", noIcon, noKey, noMark, plain,
		/* [7] */
		"Current armor", noIcon, noKey, noMark, plain,
		/* [8] */
		"Current rings", noIcon, noKey, noMark, plain,
		/* [9] */
		"Current amulet", noIcon, noKey, noMark, plain,
		/* [10] */
		"Current tools", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (107, "Move") {
	107,
	textMenuProc,
	allEnabled,
	enabled,
	"Move",
	{ /* array: 9 elements */
		/* [1] */
		"Open door", noIcon, noKey, noMark, plain,
		/* [2] */
		"Close door", noIcon, noKey, noMark, plain,
		/* [3] */
		"Kick door", noIcon, noKey, noMark, plain,
		/* [4] */
		"Search", noIcon, noKey, noMark, plain,
		/* [5] */
		"Go up stairs", noIcon, noKey, noMark, plain,
		/* [6] */
		"Go down stairs", noIcon, noKey, noMark, plain,
		/* [7] */
		"Teleport", noIcon, noKey, noMark, plain,
		/* [8] */
		"Wait", noIcon, noKey, noMark, plain,
		/* [9] */
		"Engrave message", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (108, "Extended Commands") {
	108,
	textMenuProc,
	allEnabled,
	enabled,
	"Extended",
	{ /* array: 14 elements */
		/* [1] */
		"Chat", noIcon, noKey, noMark, plain,
		/* [2] */
		"Dip object", noIcon, noKey, noMark, plain,
		/* [3] */
		"Force chest lock", noIcon, noKey, noMark, plain,
		/* [4] */
		"Jump", noIcon, noKey, noMark, plain,
		/* [5] */
		"Loot box", noIcon, noKey, noMark, plain,
		/* [6] */
		"Use monster ability", noIcon, noKey, noMark, plain,
		/* [7] */
		"Name object", noIcon, noKey, noMark, plain,
		/* [8] */
		"Offer sacrifice", noIcon, noKey, noMark, plain,
		/* [9] */
		"Pray", noIcon, noKey, noMark, plain,
		/* [10] */
		"Rub lamp", noIcon, noKey, noMark, plain,
		/* [11] */
		"Sit down", noIcon, noKey, noMark, plain,
		/* [12] */
		"Turn undead", noIcon, noKey, noMark, plain,
		/* [13] */
		"Untrap object", noIcon, noKey, noMark, plain,
		/* [14] */
		"Wipe face", noIcon, noKey, noMark, plain
	}
};

resource 'FOND' (151, "HackFont", preload) {
	proportionalFont,
	dontUseFractWidthTable,
	useIntegerExtra,
	useFractEnable,
	canAdjustCharSpacing,
	noCharWidthTable,
	noImageHeightTable,
	151,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	1,
	{ /* array FontEntries: 1 elements */
		/* [1] */
		9, 0, 19337
	},
	{ /* array: 0 elements */
	},
	{ /* array: 0 elements */
	},
	{ /* array: 0 elements */
	},
	{ /* array: 0 elements */
	}
};

resource 'FONT' (19337, purgeable) {
	doExpandFont,
	proportionalFont,
	blackFont,
	notSynthetic,
	nofctbRsrc,
	oneBit,
	noCharWidthTable,
	noImageHeightTable,
	0,
	254,
	6,
	0,
	-9,
	6,
	11,
	9,
	2,
	0,
	63,
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
	$"00 00 01 B0 00 00 00 00 00 00 28 82 00 00 00 00"
	$"00 52 80 00 00 60 00 00 34 00 00 04 30 80 0A D6"
	$"B1 12 80 0B 40 52 88 41 00 80 09 2A 80 A0 28 02"
	$"84 28 00 2A 00 28 41 1F 81 FF E0 03 F0 00 00 00"
	$"E7 00 40 00 F0 00 00 00 40 00 00 1C C0 00 00 10"
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
	$"00 00 00 00 00 00 80 00 00 00 00 00 00 00 00 E0"
	$"00 A1 10 04 30 08 02 05 01 44 00 08 04 11 00 00"
	$"00 C0 00 82 44 26 D8 00 00 04 51 00 00 2B F1 12"
	$"80 0B 40 52 88 41 00 80 09 2A 80 A0 28 02 84 28"
	$"00 2A 00 28 41 1F 81 FF E0 1A 10 00 00 00 48 80"
	$"A0 05 07 80 00 08 40 06 00 13 20 00 D5 39 EC 4C"
	$"20 00 05 CB 9C 2F BB EE 70 00 0E 73 BC EF 7F EE"
	$"8F 0C 61 18 BB CE F3 BF 18 C6 31 FF 1A 02 04 00"
	$"10 18 21 30 80 00 00 00 04 00 00 00 01 53 5D F2"
	$"29 42 48 14 A1 5A B9 DF 03 D4 A2 28 8A 74 41 28"
	$"F8 84 88 4B 45 D8 80 04 92 40 0A D6 B1 12 80 0B"
	$"40 52 88 41 00 80 09 2A 80 A0 28 02 84 28 00 2A"
	$"00 28 41 1F 81 FF E0 26 00 7C 00 6C E8 B8 80 0A"
	$"08 40 24 34 40 09 00 12 41 ED DF D6 B2 92 A9 00"
	$"06 3C 62 68 40 31 88 20 91 8C 63 18 C2 11 8A 0C"
	$"A1 BC C6 31 8C 49 18 C5 51 0D 0D 01 04 00 10 20"
	$"20 10 80 00 00 00 04 00 00 00 01 55 A3 F0 00 00"
	$"30 00 00 00 46 30 05 00 00 00 00 8C 49 05 44 80"
	$"00 00 66 64 00 05 54 00 00 2B F1 12 80 0B 40 52"
	$"88 41 00 80 09 2A 80 A0 28 02 84 28 00 2A 00 28"
	$"41 1F 81 FF E0 46 00 24 00 13 58 C4 40 7A 08 7F"
	$"22 54 48 19 70 72 81 25 85 52 D4 21 71 00 0A 68"
	$"42 AF 78 31 8D 5F 41 EC 63 08 C2 10 8A 0D 21 5A"
	$"C6 31 8C 09 18 C4 91 14 88 00 7F 9C F7 73 FD 32"
	$"FA CE F3 EC FF 8C 6B 18 FD 50 20 A7 3D EF 7B 9C"
	$"E7 24 C6 30 75 1C E7 46 31 8C 5D CF C5 CF 9D 1B"
	$"56 64 80 02 AA C0 0A D6 B1 F2 83 FB 7F D2 F8 41"
	$"00 80 09 EA FF BF EF FE FF 2B F0 2B F0 2B F1 1F"
	$"81 FF EE CA 0F 91 F9 11 5F C5 DB 97 F8 40 F9 90"
	$"40 E6 F8 53 FD 25 8F B9 48 21 AF CF 8A A8 8D 20"
	$"C4 4E 88 80 22 AF FD 08 FB D3 FA 0E 21 19 C7 D1"
	$"F3 89 18 C4 8A 24 88 00 8C 63 18 A4 63 34 D7 31"
	$"8C 73 04 8C 6A A8 8A 08 20 A8 C6 31 8C 63 18 A4"
	$"FF FE AF A3 18 C6 31 8C 6B 02 78 91 A3 1C CD D9"
	$"1F FC 32 D3 20 2B FF 1E FC 43 42 1F 8F FF FF FF"
	$"FF 2E 20 00 20 00 00 FC 0F FE 4F FC 4F FF FF FF"
	$"F1 4A 05 0A 29 11 58 C6 35 96 09 7F 22 50 7F 10"
	$"F8 80 1D 25 85 15 B5 21 21 00 13 29 03 F0 C4 91"
	$"78 5F 44 F4 63 08 C2 11 8A 8D 21 18 C6 11 88 49"
	$"18 D4 84 44 48 00 8C 61 1F A4 63 3C D6 31 8C 60"
	$"E4 8C 6A 48 91 50 20 EF C6 31 8C 3F FF A4 C6 30"
	$"FD 23 18 C6 31 8C 69 0F C8 91 A3 18 C4 02 10 08"
	$"43 E4 9A D6 B1 F2 97 FB 7B F0 78 80 04 80 09 EB"
	$"EF FE EF FE FF 03 F2 83 FA 2B F0 9F FF F8 11 46"
	$"05 12 29 10 E8 C6 3B A6 08 40 24 30 40 E0 FE 80"
	$"1D 25 00 56 B2 12 01 00 12 2A 22 28 C4 91 08 20"
	$"80 84 63 18 C2 11 8A 8C A1 18 C6 11 8C 49 15 6D"
	$"44 84 48 00 9C 61 18 24 63 32 D6 31 8C 60 14 9A"
	$"AA A8 A1 50 22 48 4E 73 9C 21 08 24 C6 30 A5 23"
	$"18 CE 71 8C 6B 12 5C 93 A3 38 C7 FE 30 08 80 E4"
	$"90 2B F1 12 94 4B 4A 00 00 80 04 80 09 28 28 02"
	$"A8 02 80 00 42 80 4A 28 40 9F FF F8 11 46 05 26"
	$"29 10 48 AA 20 A5 08 7F 00 10 49 00 71 00 01 25"
	$"80 3A 4D 0C 00 10 61 CF DC 27 38 8E 75 00 04 74"
	$"7C EF 7E 0E 8F 74 7F 18 BA 0E 8B 88 E2 46 24 FE"
	$"38 FC 6F 9E F7 A3 E3 31 D6 2E F3 E1 E3 69 15 17"
	$"FD 50 1C 47 B5 AD 6B DE F7 A4 C6 3F BD DC E7 35"
	$"AF 73 9D E2 48 8D 9C D8 C4 01 C0 00 E0 D3 2A D6"
	$"B1 12 94 4B 4A 00 00 80 04 80 09 28 28 02 A8 02"
	$"80 00 42 80 4A 28 40 9F FF F8 0E DA 05 7D CE 90"
	$"E7 6D C0 78 F8 40 FF F2 40 00 01 00 01 ED 00 10"
	$"00 00 00 10 20 00 00 00 00 00 01 00 00 00 00 00"
	$"00 00 00 00 00 00 00 01 00 00 00 00 00 00 20 00"
	$"00 00 00 00 40 20 00 00 80 40 00 00 00 00 80 E0"
	$"04 E0 00 00 01 00 00 00 00 00 00 00 00 00 01 00"
	$"08 00 0C 80 00 00 00 00 00 00 00 00 00 2B F1 12"
	$"94 4B 4A 00 00 80 04 80 09 28 28 02 A8 02 80 00"
	$"42 80 4A 28 40 9F FF F8 00 40 00 00 08 00 00 00"
	$"00 40 0F C0 00 12 40 00 00 00 00 00 00 00 00 00"
	$"00 20 00 00 00 00 00 00 02 00 00 00 00 00 00 00"
	$"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
	$"00 03 80 C0 00 00 80 40 00 00 00 07 00 00 08 00"
	$"00 00 02 00 00 00 00 00 00 00 00 00 0E 00 00 00"
	$"03 00 00 00 00 00 00 00 00 00 0A D6 B1 12 94 4B"
	$"4A 00 00 80 04 80 09 28 28 02 A8 02 80 00 42 80"
	$"4A 28 40 9F FF F8 00 00 00 00 08 00 00 00 00 80"
	$"00 00 00 11 80 00 00 00 00 00",
	{ /* array: 257 elements */
		/* [1] */
		0,
		/* [2] */
		0,
		/* [3] */
		0,
		/* [4] */
		0,
		/* [5] */
		0,
		/* [6] */
		0,
		/* [7] */
		0,
		/* [8] */
		0,
		/* [9] */
		0,
		/* [10] */
		0,
		/* [11] */
		0,
		/* [12] */
		0,
		/* [13] */
		0,
		/* [14] */
		0,
		/* [15] */
		0,
		/* [16] */
		0,
		/* [17] */
		0,
		/* [18] */
		0,
		/* [19] */
		0,
		/* [20] */
		0,
		/* [21] */
		0,
		/* [22] */
		0,
		/* [23] */
		0,
		/* [24] */
		0,
		/* [25] */
		0,
		/* [26] */
		0,
		/* [27] */
		0,
		/* [28] */
		0,
		/* [29] */
		0,
		/* [30] */
		0,
		/* [31] */
		0,
		/* [32] */
		0,
		/* [33] */
		0,
		/* [34] */
		0,
		/* [35] */
		1,
		/* [36] */
		4,
		/* [37] */
		9,
		/* [38] */
		14,
		/* [39] */
		19,
		/* [40] */
		24,
		/* [41] */
		26,
		/* [42] */
		29,
		/* [43] */
		32,
		/* [44] */
		37,
		/* [45] */
		42,
		/* [46] */
		44,
		/* [47] */
		49,
		/* [48] */
		50,
		/* [49] */
		54,
		/* [50] */
		59,
		/* [51] */
		61,
		/* [52] */
		66,
		/* [53] */
		71,
		/* [54] */
		76,
		/* [55] */
		81,
		/* [56] */
		86,
		/* [57] */
		91,
		/* [58] */
		96,
		/* [59] */
		101,
		/* [60] */
		102,
		/* [61] */
		104,
		/* [62] */
		107,
		/* [63] */
		112,
		/* [64] */
		115,
		/* [65] */
		120,
		/* [66] */
		125,
		/* [67] */
		130,
		/* [68] */
		135,
		/* [69] */
		140,
		/* [70] */
		145,
		/* [71] */
		150,
		/* [72] */
		155,
		/* [73] */
		160,
		/* [74] */
		165,
		/* [75] */
		168,
		/* [76] */
		173,
		/* [77] */
		178,
		/* [78] */
		183,
		/* [79] */
		188,
		/* [80] */
		193,
		/* [81] */
		198,
		/* [82] */
		203,
		/* [83] */
		208,
		/* [84] */
		213,
		/* [85] */
		218,
		/* [86] */
		223,
		/* [87] */
		228,
		/* [88] */
		233,
		/* [89] */
		238,
		/* [90] */
		243,
		/* [91] */
		248,
		/* [92] */
		253,
		/* [93] */
		255,
		/* [94] */
		259,
		/* [95] */
		261,
		/* [96] */
		264,
		/* [97] */
		270,
		/* [98] */
		272,
		/* [99] */
		277,
		/* [100] */
		282,
		/* [101] */
		287,
		/* [102] */
		292,
		/* [103] */
		297,
		/* [104] */
		301,
		/* [105] */
		306,
		/* [106] */
		311,
		/* [107] */
		312,
		/* [108] */
		315,
		/* [109] */
		320,
		/* [110] */
		321,
		/* [111] */
		326,
		/* [112] */
		331,
		/* [113] */
		336,
		/* [114] */
		341,
		/* [115] */
		346,
		/* [116] */
		351,
		/* [117] */
		356,
		/* [118] */
		360,
		/* [119] */
		365,
		/* [120] */
		370,
		/* [121] */
		375,
		/* [122] */
		380,
		/* [123] */
		385,
		/* [124] */
		390,
		/* [125] */
		393,
		/* [126] */
		394,
		/* [127] */
		397,
		/* [128] */
		402,
		/* [129] */
		402,
		/* [130] */
		407,
		/* [131] */
		412,
		/* [132] */
		417,
		/* [133] */
		422,
		/* [134] */
		427,
		/* [135] */
		432,
		/* [136] */
		437,
		/* [137] */
		442,
		/* [138] */
		447,
		/* [139] */
		452,
		/* [140] */
		457,
		/* [141] */
		460,
		/* [142] */
		463,
		/* [143] */
		465,
		/* [144] */
		470,
		/* [145] */
		475,
		/* [146] */
		480,
		/* [147] */
		485,
		/* [148] */
		490,
		/* [149] */
		495,
		/* [150] */
		500,
		/* [151] */
		505,
		/* [152] */
		510,
		/* [153] */
		515,
		/* [154] */
		520,
		/* [155] */
		525,
		/* [156] */
		530,
		/* [157] */
		535,
		/* [158] */
		540,
		/* [159] */
		545,
		/* [160] */
		550,
		/* [161] */
		555,
		/* [162] */
		560,
		/* [163] */
		562,
		/* [164] */
		567,
		/* [165] */
		572,
		/* [166] */
		577,
		/* [167] */
		582,
		/* [168] */
		586,
		/* [169] */
		590,
		/* [170] */
		595,
		/* [171] */
		600,
		/* [172] */
		605,
		/* [173] */
		611,
		/* [174] */
		617,
		/* [175] */
		618,
		/* [176] */
		623,
		/* [177] */
		628,
		/* [178] */
		633,
		/* [179] */
		638,
		/* [180] */
		643,
		/* [181] */
		644,
		/* [182] */
		648,
		/* [183] */
		652,
		/* [184] */
		657,
		/* [185] */
		662,
		/* [186] */
		666,
		/* [187] */
		671,
		/* [188] */
		674,
		/* [189] */
		679,
		/* [190] */
		684,
		/* [191] */
		689,
		/* [192] */
		693,
		/* [193] */
		697,
		/* [194] */
		700,
		/* [195] */
		706,
		/* [196] */
		712,
		/* [197] */
		715,
		/* [198] */
		721,
		/* [199] */
		727,
		/* [200] */
		730,
		/* [201] */
		734,
		/* [202] */
		738,
		/* [203] */
		742,
		/* [204] */
		748,
		/* [205] */
		754,
		/* [206] */
		758,
		/* [207] */
		764,
		/* [208] */
		770,
		/* [209] */
		776,
		/* [210] */
		782,
		/* [211] */
		788,
		/* [212] */
		794,
		/* [213] */
		798,
		/* [214] */
		801,
		/* [215] */
		804,
		/* [216] */
		808,
		/* [217] */
		814,
		/* [218] */
		820,
		/* [219] */
		824,
		/* [220] */
		827,
		/* [221] */
		833,
		/* [222] */
		839,
		/* [223] */
		842,
		/* [224] */
		845,
		/* [225] */
		851,
		/* [226] */
		857,
		/* [227] */
		862,
		/* [228] */
		868,
		/* [229] */
		873,
		/* [230] */
		878,
		/* [231] */
		884,
		/* [232] */
		889,
		/* [233] */
		895,
		/* [234] */
		900,
		/* [235] */
		905,
		/* [236] */
		910,
		/* [237] */
		915,
		/* [238] */
		920,
		/* [239] */
		926,
		/* [240] */
		932,
		/* [241] */
		938,
		/* [242] */
		944,
		/* [243] */
		949,
		/* [244] */
		952,
		/* [245] */
		955,
		/* [246] */
		958,
		/* [247] */
		962,
		/* [248] */
		967,
		/* [249] */
		972,
		/* [250] */
		976,
		/* [251] */
		981,
		/* [252] */
		982,
		/* [253] */
		987,
		/* [254] */
		991,
		/* [255] */
		995,
		/* [256] */
		998,
		/* [257] */
		1004
	},
	{ /* array: 257 elements */
		/* [1] */
		6,
		/* [2] */
		6,
		/* [3] */
		6,
		/* [4] */
		6,
		/* [5] */
		6,
		/* [6] */
		6,
		/* [7] */
		6,
		/* [8] */
		6,
		/* [9] */
		6,
		/* [10] */
		6,
		/* [11] */
		6,
		/* [12] */
		6,
		/* [13] */
		6,
		/* [14] */
		6,
		/* [15] */
		6,
		/* [16] */
		6,
		/* [17] */
		6,
		/* [18] */
		6,
		/* [19] */
		6,
		/* [20] */
		6,
		/* [21] */
		6,
		/* [22] */
		6,
		/* [23] */
		6,
		/* [24] */
		6,
		/* [25] */
		6,
		/* [26] */
		6,
		/* [27] */
		6,
		/* [28] */
		6,
		/* [29] */
		6,
		/* [30] */
		6,
		/* [31] */
		6,
		/* [32] */
		6,
		/* [33] */
		1542,
		/* [34] */
		518,
		/* [35] */
		262,
		/* [36] */
		6,
		/* [37] */
		6,
		/* [38] */
		6,
		/* [39] */
		6,
		/* [40] */
		518,
		/* [41] */
		262,
		/* [42] */
		518,
		/* [43] */
		6,
		/* [44] */
		6,
		/* [45] */
		262,
		/* [46] */
		6,
		/* [47] */
		518,
		/* [48] */
		262,
		/* [49] */
		6,
		/* [50] */
		518,
		/* [51] */
		6,
		/* [52] */
		6,
		/* [53] */
		6,
		/* [54] */
		6,
		/* [55] */
		6,
		/* [56] */
		6,
		/* [57] */
		6,
		/* [58] */
		6,
		/* [59] */
		518,
		/* [60] */
		262,
		/* [61] */
		262,
		/* [62] */
		6,
		/* [63] */
		262,
		/* [64] */
		6,
		/* [65] */
		6,
		/* [66] */
		6,
		/* [67] */
		6,
		/* [68] */
		6,
		/* [69] */
		6,
		/* [70] */
		6,
		/* [71] */
		6,
		/* [72] */
		6,
		/* [73] */
		6,
		/* [74] */
		262,
		/* [75] */
		6,
		/* [76] */
		6,
		/* [77] */
		6,
		/* [78] */
		6,
		/* [79] */
		6,
		/* [80] */
		6,
		/* [81] */
		6,
		/* [82] */
		6,
		/* [83] */
		6,
		/* [84] */
		6,
		/* [85] */
		6,
		/* [86] */
		6,
		/* [87] */
		6,
		/* [88] */
		6,
		/* [89] */
		6,
		/* [90] */
		6,
		/* [91] */
		6,
		/* [92] */
		518,
		/* [93] */
		262,
		/* [94] */
		518,
		/* [95] */
		262,
		/* [96] */
		6,
		/* [97] */
		262,
		/* [98] */
		6,
		/* [99] */
		6,
		/* [100] */
		6,
		/* [101] */
		6,
		/* [102] */
		6,
		/* [103] */
		262,
		/* [104] */
		6,
		/* [105] */
		6,
		/* [106] */
		518,
		/* [107] */
		6,
		/* [108] */
		6,
		/* [109] */
		518,
		/* [110] */
		6,
		/* [111] */
		6,
		/* [112] */
		6,
		/* [113] */
		6,
		/* [114] */
		6,
		/* [115] */
		6,
		/* [116] */
		6,
		/* [117] */
		262,
		/* [118] */
		6,
		/* [119] */
		6,
		/* [120] */
		6,
		/* [121] */
		6,
		/* [122] */
		6,
		/* [123] */
		6,
		/* [124] */
		518,
		/* [125] */
		518,
		/* [126] */
		262,
		/* [127] */
		6,
		/* [128] */
		0,
		/* [129] */
		6,
		/* [130] */
		6,
		/* [131] */
		6,
		/* [132] */
		6,
		/* [133] */
		6,
		/* [134] */
		6,
		/* [135] */
		6,
		/* [136] */
		6,
		/* [137] */
		6,
		/* [138] */
		6,
		/* [139] */
		6,
		/* [140] */
		262,
		/* [141] */
		262,
		/* [142] */
		262,
		/* [143] */
		6,
		/* [144] */
		6,
		/* [145] */
		6,
		/* [146] */
		6,
		/* [147] */
		6,
		/* [148] */
		6,
		/* [149] */
		6,
		/* [150] */
		6,
		/* [151] */
		6,
		/* [152] */
		6,
		/* [153] */
		6,
		/* [154] */
		6,
		/* [155] */
		6,
		/* [156] */
		6,
		/* [157] */
		6,
		/* [158] */
		6,
		/* [159] */
		6,
		/* [160] */
		6,
		/* [161] */
		6,
		/* [162] */
		518,
		/* [163] */
		6,
		/* [164] */
		6,
		/* [165] */
		6,
		/* [166] */
		6,
		/* [167] */
		262,
		/* [168] */
		262,
		/* [169] */
		6,
		/* [170] */
		6,
		/* [171] */
		6,
		/* [172] */
		6,
		/* [173] */
		6,
		/* [174] */
		774,
		/* [175] */
		6,
		/* [176] */
		6,
		/* [177] */
		6,
		/* [178] */
		6,
		/* [179] */
		6,
		/* [180] */
		774,
		/* [181] */
		6,
		/* [182] */
		6,
		/* [183] */
		6,
		/* [184] */
		6,
		/* [185] */
		6,
		/* [186] */
		6,
		/* [187] */
		518,
		/* [188] */
		6,
		/* [189] */
		6,
		/* [190] */
		6,
		/* [191] */
		6,
		/* [192] */
		6,
		/* [193] */
		774,
		/* [194] */
		6,
		/* [195] */
		6,
		/* [196] */
		774,
		/* [197] */
		6,
		/* [198] */
		6,
		/* [199] */
		774,
		/* [200] */
		518,
		/* [201] */
		518,
		/* [202] */
		518,
		/* [203] */
		6,
		/* [204] */
		6,
		/* [205] */
		518,
		/* [206] */
		6,
		/* [207] */
		6,
		/* [208] */
		6,
		/* [209] */
		6,
		/* [210] */
		6,
		/* [211] */
		6,
		/* [212] */
		518,
		/* [213] */
		774,
		/* [214] */
		774,
		/* [215] */
		518,
		/* [216] */
		6,
		/* [217] */
		6,
		/* [218] */
		6,
		/* [219] */
		774,
		/* [220] */
		6,
		/* [221] */
		6,
		/* [222] */
		6,
		/* [223] */
		774,
		/* [224] */
		6,
		/* [225] */
		6,
		/* [226] */
		6,
		/* [227] */
		6,
		/* [228] */
		6,
		/* [229] */
		6,
		/* [230] */
		6,
		/* [231] */
		6,
		/* [232] */
		6,
		/* [233] */
		6,
		/* [234] */
		6,
		/* [235] */
		6,
		/* [236] */
		6,
		/* [237] */
		6,
		/* [238] */
		6,
		/* [239] */
		6,
		/* [240] */
		6,
		/* [241] */
		6,
		/* [242] */
		6,
		/* [243] */
		262,
		/* [244] */
		262,
		/* [245] */
		774,
		/* [246] */
		6,
		/* [247] */
		6,
		/* [248] */
		6,
		/* [249] */
		262,
		/* [250] */
		6,
		/* [251] */
		518,
		/* [252] */
		6,
		/* [253] */
		6,
		/* [254] */
		6,
		/* [255] */
		262,
		/* [256] */
		6,
		/* [257] */
		-1
	}
};

resource 'PICT' (100) {
	588,
	{32, 121, 46, 403},
	$"11 01 A0 00 82 A0 00 8E 01 00 0A 00 20 00 71 02"
	$"D0 02 40 98 00 24 00 00 00 08 00 0E 01 28 00 00"
	$"00 08 00 0E 01 22 00 20 00 79 00 2E 01 93 00 01"
	$"21 0F F8 7E 00 00 7F 3F 80 00 01 E0 00 7E 00 3C"
	$"00 1E FE 00 06 01 E0 00 00 3F 03 F0 FA 00 02 01"
	$"E0 00 22 05 38 18 00 00 1C 0E FE 00 06 E0 00 E7"
	$"00 E7 00 3F FD 00 08 E0 00 00 0F 03 C0 00 00 1C"
	$"FC 00 01 E0 00 25 05 3C 18 00 1C 1C 0E FE 00 06"
	$"E0 00 E3 80 E7 00 77 FE 00 0B 70 E0 00 00 0F 87"
	$"C0 00 00 1C 00 07 FE 00 01 E0 00 24 05 3E 18 00"
	$"1C 1C 0E FE 00 06 E0 00 03 81 C3 80 70 FE 00 06"
	$"70 E0 00 00 0F 87 C0 FD 00 00 07 FE 00 01 E0 00"
	$"24 05 3F 18 00 1C 1C 0E FE 00 06 E0 00 03 81 C3"
	$"80 70 FE 00 06 70 E0 00 00 0F 87 C0 FD 00 00 07"
	$"FE 00 01 E0 00 25 23 37 18 3E 3F 1C 0E 07 81 F0"
	$"EF 80 07 01 C3 81 FC 7E 3D C0 FC FF 07 C0 0D CD"
	$"C0 F0 3E 3C FF 8F C7 E1 FC FF 00 25 23 33 98 77"
	$"1C 1F FE 1C C3 9C E6 00 3E 01 C3 80 70 E7 1F C0"
	$"70 F7 8E E0 0D CD C3 98 73 9C 7B C7 0E 73 9C F7"
	$"80 25 23 33 D8 E3 9C 1C 0E 1C E7 1C EC 00 07 01"
	$"C3 80 71 C3 9E 00 70 E3 9C 70 0D CD C3 9C E3 9C"
	$"71 C7 1C 3B 0C E3 80 25 23 31 D8 E3 9C 1C 0E 00"
	$"E7 00 F8 00 03 81 C3 80 71 C3 9C 00 70 E3 9C 70"
	$"0C F9 C0 1C E0 1C 71 C7 1C 3B C0 E3 80 25 23 30"
	$"F8 FF 9C 1C 0E 07 E7 00 F8 00 03 81 C3 80 71 C3"
	$"9C 00 70 E3 9F F0 0C F9 C0 FC E0 1C 71 C7 1C 39"
	$"F8 E3 80 25 23 30 F8 E0 1C 1C 0E 1C E7 00 FC 00"
	$"03 81 C3 80 71 C3 9C 00 70 E3 9C 00 0C F9 C3 9C"
	$"E0 1C 71 C7 1C 38 3C E3 80 25 23 30 78 E1 9C 1C"
	$"0E 38 E7 0C EE 01 C3 80 E7 00 71 C3 9C 00 70 E3"
	$"9C 30 0C 71 C7 1C E1 9C 71 C7 1C 3B 0C E3 80 25"
	$"23 30 38 73 9D 9C 0E 39 E3 9C E7 01 C7 1C E7 00"
	$"70 E7 1C 00 76 E3 8E 70 0C 71 C7 3C 73 9C 71 C7"
	$"6E 73 9C E3 80 25 23 FC 18 3F 0F 7F 3F 9F F1 F9"
	$"FF C0 FE 1C 3C 00 F8 7E 3E 00 3D F7 C7 E0 3F 77"
	$"F3 FE 3F 3E FB E3 C7 E3 F9 F7 C0 A0 00 8F A0 00"
	$"83 FF"
};
