/*	SCCS Id: @(#)monst.c	3.0	89/11/21
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

/* since this file is also used in auxiliary programs, don't include all the
 * function declarations for all of nethack
 */
#define EXTERN_H
#include "config.h"
#include "permonst.h"
#include "monsym.h"
#include "eshk.h"
#include "vault.h"
#include "epri.h"

#define NO_ATTK 	{ 0, 0, 0, 0 }

#ifdef C
#undef C
#endif
#ifdef TEXTCOLOR
#include "color.h"
#define C(color)	color
#define HI_DOMESTIC	WHITE		/* use for player + friendlies */
#define HI_LORD 	MAGENTA
#else
#define C(color)
#endif

#ifndef SPLITMON_2
struct permonst playermon = {		/* used by weapons bonus code */
	"player", S_HUMAN, 1, 10, 10, 0, 0, G_GENO | G_NOGEN,
	{ { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	45, 400, PL_NSIZ, MS_SILENT, MZ_HUMAN,
	M1_NEEDPICK | M1_HUMANOID | M1_COLLECT,
	M2_HUMAN | M2_STRONG, C(HI_DOMESTIC)
},	*uasmon = &playermon;
#endif /* SPLITMON_2 */

/*
 *	Rule #1:	monsters of a given class are contiguous in the
 *			mons[] array.
 *
 *	Rule #2:	monsters of a given class are presented in ascending
 *			order of strength.
 *
 *	Rule #3:	monster frequency is included in the geno mask;
 *			the frequency can be from 0 to 7.  0's will also
 *			be skipped during generation.
 *
 * Guidelines for color assignment:
 *
 *	* Use the same color for all `growth stages' of a monster (ex.
 *	  little dog/big dog, baby naga/full-grown naga.
 *
 *	* Use colors given in names wherever possible. If the class has `real'
 *	  members with strong color associations, use those.
 *
 *	* Favor `cool' colors for cold-resistent monsters, `warm' ones for
 *	  fire-resistent ones.
 *
 *	* Try to reserve purple (magenta) for powerful `ruler' monsters (queen
 *	  bee, kobold lord, &c.).
 *
 *	* Subject to all these constraints, try to use color to make as many
 *	  distinctions as the / command (that is, within a monster letter
 *	  distinct names should map to distinct colors).
 *
 * The aim in assigning colors is to be consistent enough so a player can
 * become `intuitive' about them, deducing some or all of these rules
 * unconsciously. Use your common sense.
 */

#if defined(SMALLDATA) && !defined(MAKEDEFS_C)
		/* if it's for SMALLDATA, say so, right? (KL) */
struct permonst *mons;	   /* for SMALLDATA - mons data stored in NetHack app */
#else
#ifndef SPLITMON_2
struct permonst mons[] = {
/*	ants	*/
	{ "giant ant",	S_ANT, 2, 18, 3, 0, 0, (G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, MZ_TINY, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BROWN) },
	{ "soldier ant", S_ANT, 3, 18, 3, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_STNG, AD_DRST, 3, 4 },
	  NO_ATTK, NO_ATTK, NO_ATTK }, 2, 20, 0, MS_SILENT, MZ_TINY,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BLUE) },
	{ "fire ant", S_ANT, 3, 18, 3, 10, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_FIRE, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, MZ_TINY, M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(RED) },
	{ "giant beetle", S_ANT, 5, 6, 4, 0, 0, (G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_NOHANDS | M1_POIS |
	  M1_POIS_RES, M2_HOSTILE | M2_CARNIVORE, C(BLACK) },
	{ "killer bee", S_ANT, 1, 18, -1, 0, 0, (G_GENO | G_LGROUP | 2),
	  { { AT_STNG, AD_DRST, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_BUZZ, MZ_TINY, M1_ANIMAL | M1_FLY | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES, M2_HOSTILE, C(YELLOW) },
	{ "queen bee", S_ANT, 9, 24, -4, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_STNG, AD_DRST, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_BUZZ, MZ_TINY, M1_ANIMAL | M1_FLY | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES, M2_HOSTILE | M2_PRINCE, C(HI_LORD) },
/*	blobs	*/
	{ "acid blob", S_BLOB, 1, 3, 8, 0, 0, (G_GENO | 2),
	  { { AT_NONE, AD_ACID, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, MZ_TINY,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_SLEE_RES | M1_STON_RES |
	  M1_ACID, M2_WANDER, C(GREEN) },
	{ "quivering blob", S_BLOB, 5, 1, 8, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, MZ_SMALL,
	  M1_NOEYES | M1_NOLIMBS | M1_POIS_RES,
	  M2_WANDER | M2_HOSTILE, C(WHITE) },
	{ "gelatinous cube", S_BLOB, 6, 6, 8, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_PLYS, 2, 4 }, { AT_NONE, AD_PLYS, 1, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_SILENT, MZ_LARGE,
	  M1_NOEYES | M1_NOLIMBS | M1_FIRE_RES | M1_COLD_RES | M1_ELEC_RES |
	  M1_SLEE_RES, M2_WANDER | M2_HOSTILE | M2_OMNIVORE, C(CYAN) },
/*	cockatrice	*/
	{ "cockatrice", S_COCKATRICE, 5, 6, 6, 30, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 1, 3 }, { AT_TUCH, AD_STON, 0, 0 },
	    { AT_NONE, AD_STON, 0, 0 }, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_HISS, MZ_SMALL,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS_RES | M1_STON_RES,
	  M2_HOSTILE | M2_EGGS, C(YELLOW) },
/*	dog	*/
	{ "little dog", S_DOG, 2, 18, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_BARK, MZ_SMALL,
	  M1_ANIMAL | M1_NOHANDS, M2_CARNIVORE | M2_DOMESTIC, C(HI_DOMESTIC) },
	{ "dog", S_DOG, 4, 16, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1 ,6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_BARK, MZ_MEDIUM,
	  M1_ANIMAL | M1_NOHANDS, M2_CARNIVORE | M2_DOMESTIC, C(HI_DOMESTIC) },
	{ "large dog", S_DOG, 6, 15, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, MZ_MEDIUM,
	  M1_ANIMAL | M1_NOHANDS, M2_STRONG | M2_CARNIVORE | M2_DOMESTIC,
	  C(HI_DOMESTIC) },
	{ "jackal", S_DOG, 0, 12, 7, 0, 0, (G_GENO | G_SGROUP | 3),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, MZ_SMALL,
	  M1_ANIMAL | M1_NOHANDS, M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "jackalwere", S_DOG, 2, 12, 7, 10, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, MZ_SMALL,
	  M1_NOPOLY | M1_NOHANDS | M1_POIS | M1_REGEN,
	  M2_WERE | M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "wolf", S_DOG, 5, 12, 4, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, MZ_SMALL,
	  M1_ANIMAL | M1_NOHANDS, M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "wolfwere", S_DOG, 5, 12, 4, 20, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_BARK, MZ_MEDIUM,
	  M1_NOPOLY | M1_NOHANDS | M1_POIS | M1_REGEN,
	  M2_WERE | M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "winter wolf", S_DOG, 7, 12, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_BREA, AD_COLD, 2, 6 },
	  NO_ATTK, NO_ATTK, NO_ATTK, },
	  30, 300, 0, MS_BARK, MZ_LARGE, M1_ANIMAL | M1_NOHANDS | M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(CYAN) },
	{ "warg", S_DOG, 7, 12, 4, 0, -5, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_BARK, MZ_MEDIUM, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "hell hound pup", S_DOG, 7, 12, 4, 20, -5,
	  (G_HELL | G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_BREA, AD_FIRE, 2, 6 },
	  NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_BARK, MZ_SMALL, M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_CARNIVORE, C(RED) },
	{ "hell hound", S_DOG, 12, 14, 2, 20, 0, (G_HELL | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BREA, AD_FIRE, 3, 6 },
	  NO_ATTK, NO_ATTK, NO_ATTK, },
	  30, 300, 0, MS_BARK, MZ_MEDIUM, M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(RED) },
#ifdef CHARON
	{ "Cerberus", S_DOG, 12, 10, 2, 20, -7, (G_HELL | G_UNIQ | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_BITE, AD_PHYS, 3, 6 },
	  { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK },
	  50, 350, 0, MS_BARK, MZ_LARGE,
	  M1_NOPOLY | M1_ANIMAL | M1_NOHANDS | M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_PNAME, C(RED) },
#endif
/*	eyes	*/
	{ "floating eye", S_EYE, 2, 1, 9, 10, 0, (G_GENO | 5),
	  { { AT_NONE, AD_PLYS, 0, 70 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, MZ_SMALL,
	  M1_FLY | M1_NOLIMBS, M2_HOSTILE, C(BLUE) },
	{ "freezing sphere", S_EYE, 6, 13, 4, 0, 0, (G_GENO | 2),
	  { { AT_EXPL, AD_COLD, 4, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, MZ_SMALL,
	  M1_FLY | M1_NOLIMBS | M1_COLD_RES, M2_HOSTILE, C(WHITE) },
/*	felines 	*/
	{ "kitten", S_FELINE, 2, 18, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_MEW, MZ_SMALL, M1_ANIMAL | M1_NOHANDS,
	  M2_WANDER | M2_CARNIVORE | M2_DOMESTIC, C(HI_DOMESTIC) },
	{ "housecat", S_FELINE, 4, 16, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_MEW, MZ_SMALL, M1_ANIMAL | M1_NOHANDS,
	  M2_CARNIVORE | M2_DOMESTIC, C(HI_DOMESTIC) },
	{ "large cat", S_FELINE, 6, 15, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_MEW, MZ_SMALL, M1_ANIMAL | M1_NOHANDS,
	  M2_STRONG | M2_CARNIVORE | M2_DOMESTIC, C(HI_DOMESTIC) },
	{ "jaguar", S_FELINE, 4, 15, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_GROWL, MZ_LARGE, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "tiger", S_FELINE, 6, 12, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_BITE, AD_PHYS, 1, 10 }, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_GROWL, MZ_LARGE, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(YELLOW) },
/*	gremlins	*/
	{ "gremlin", S_GREMLIN, 5, 12, 2, 25, -9, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 4 }, { AT_CLAW, AD_CURS, 0, 0 }, NO_ATTK },
	  10, 30, 0, MS_LAUGH, MZ_SMALL,
	  M1_SWIM | M1_HUMANOID | M1_POIS, M2_STALK, C(GREEN) },
/*	humanoids	*/
#ifdef TOLKIEN
	{ "hobbit", S_HUMANOID, 1, 9, 7, 0, 6, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_HUMANOID, MZ_SMALL,
	  M1_HUMANOID | M1_COLLECT, 0, C(GREEN) },
#endif
	{ "bugbear", S_HUMANOID, 3, 9, 5, 0, -6, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_GROWL, MZ_LARGE, M1_HUMANOID | M1_COLLECT,
	  M2_STRONG, C(BROWN) },
	{ "dwarf", S_HUMANOID,	2, 6, 4, 10, 4, (G_GENO | 3),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID | M1_GREEDY | M1_JEWELS |
	  M1_COLLECT, M2_DWARF | M2_STRONG, C(RED) },
	{ "dwarf lord", S_HUMANOID,  4, 6, 4, 10, 5, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID | M1_GREEDY | M1_JEWELS |
	  M1_COLLECT, M2_DWARF | M2_STRONG | M2_LORD, C(BLUE) },
	{ "dwarf king", S_HUMANOID,  6, 6, 4, 20, 6, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, { AT_WEAP, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_TUNNEL | M1_NEEDPICK | M1_HUMANOID | M1_GREEDY | M1_JEWELS |
	  M1_COLLECT, M2_DWARF | M2_STRONG | M2_PRINCE, C(HI_LORD) },
/*	imps & other minor demons/devils */
	{ "manes", S_IMP, 1, 3, 7, 0, -7, (G_GENO | G_LGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_CUSS, MZ_SMALL, M1_POIS, M2_STALK, C(RED) },
	{ "homunculus", S_IMP, 2, 12, 6, 10, -7, (G_GENO | 2),
	  { { AT_BITE, AD_SLEE, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, MZ_TINY,
	  M1_FLY | M1_POIS | M1_POIS_RES | M1_SLEE_RES, M2_STALK, C(GREEN) },
	{ "lemure", S_IMP, 3, 3, 7, 0, -7,
	  (G_HELL | G_GENO | G_LGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_MEDIUM, M1_POIS | M1_SLEE_RES | M1_REGEN,
	  M2_HOSTILE | M2_WANDER | M2_STALK, C(BROWN) },
	{ "imp", S_IMP, 3, 12, 2, 20, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_CUSS, MZ_TINY, M1_REGEN, M2_WANDER | M2_STALK, C(RED) },
	{ "quasit", S_IMP, 3, 15, 2, 20, -7, (G_GENO | 2),
	  { { AT_CLAW, AD_DRDX, 1, 2 }, { AT_CLAW, AD_DRDX, 1, 2 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, MZ_SMALL,
	  M1_POIS_RES | M1_REGEN, M2_STALK, C(BLUE) },
	{ "tengu", S_IMP, 6, 13, 5, 30, 7, (G_GENO | 3),
	  { { AT_BITE, AD_PHYS, 1, 7 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_SQAWK, MZ_SMALL,
	  M1_POIS_RES | M1_TPORT | M1_TPORT_CONTROL, M2_STALK, C(CYAN) },
/*	jellies 	*/
	{ "blue jelly", S_JELLY, 4, 0, 8, 10, 0, (G_GENO | 2),
	  { { AT_NONE, AD_COLD, 0, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, MZ_MEDIUM,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_COLD_RES | M1_POIS_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(BLUE) },
	{ "spotted jelly", S_JELLY, 5, 0, 8, 10, 0, (G_GENO | 1),
	  { { AT_NONE, AD_ACID, 0, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, MZ_MEDIUM,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_STON_RES | M1_ACID,
	  M2_HOSTILE | M2_OMNIVORE, C(GREEN) },
	{ "ochre jelly", S_JELLY, 6, 3, 8, 20, 0, (G_GENO | 2),
	  { { AT_ENGL, AD_ACID, 3, 6 }, { AT_NONE, AD_ACID, 0, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, MZ_MEDIUM,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_STON_RES | M1_ACID,
	  M2_HOSTILE | M2_OMNIVORE, C(BROWN) },
/*	kobolds 	*/
	{ "kobold", S_KOBOLD,  0, 6, 7, 0, -2, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_ORC, MZ_SMALL, M1_HUMANOID | M1_POIS | M1_COLLECT,
	  M2_HOSTILE, C(BROWN) },
	{ "large kobold", S_KOBOLD,  1, 6, 6, 0, -3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_ORC, MZ_SMALL, M1_HUMANOID | M1_POIS | M1_COLLECT,
	  M2_HOSTILE, C(RED) },
	{ "kobold lord", S_KOBOLD,  2, 6, 5, 0, -4, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC, MZ_SMALL, M1_HUMANOID | M1_POIS | M1_COLLECT,
	  M2_HOSTILE | M2_LORD, C(HI_LORD) },
	{ "kobold shaman", S_KOBOLD, 1, 6, 6, 10, -4, (G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_ORC, MZ_SMALL, M1_HUMANOID | M1_POIS | M1_MAGIC,
	  M2_HOSTILE, C(HI_ZAP) },
/*	leprechauns	*/
	{ "leprechaun", S_LEPRECHAUN, 5, 15, 8, 20, 0, (G_GENO | 4),
	  { { AT_CLAW, AD_SGLD, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_LAUGH, MZ_TINY, M1_HUMANOID | M1_TPORT | M1_GREEDY,
	  M2_HOSTILE, C(GREEN) },
/*	mimics	*/
	{ "small mimic", S_MIMIC, 7, 3, 7, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, MZ_MEDIUM,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "large mimic", S_MIMIC, 8, 3, 7, 10, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_STCK, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT, MZ_LARGE,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(RED) },
	{ "giant mimic", S_MIMIC, 9, 3, 7, 20, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_STCK, 3, 6 }, { AT_CLAW, AD_STCK, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 500, 0, MS_SILENT, MZ_LARGE,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(HI_LORD) },
/*	nymphs	*/
	{ "wood nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_TPORT | M1_COLLECT, M2_HOSTILE | M2_FEM, C(GREEN) },
	{ "water nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_TPORT | M1_COLLECT | M1_SWIM,
	  M2_HOSTILE | M2_FEM, C(BLUE) },
	{ "mountain nymph", S_NYMPH, 3, 12, 9, 20, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_SITM, 0, 0 }, { AT_CLAW, AD_SEDU, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_TPORT | M1_COLLECT, M2_HOSTILE | M2_FEM, C(BROWN) },
/*	orcs	*/
	{ "goblin", S_ORC,  0, 6, 6, 0, -3, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_ORC, MZ_SMALL,
	  M1_HUMANOID | M1_COLLECT, M2_ORC, C(GRAY) },
	{ "hobgoblin", S_ORC,  1, 9, 6, 0, -4, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_COLLECT, M2_ORC | M2_STRONG, C(BROWN) },
	/* "orc" for zombie corpses only; they don't get created at random */
	{ "orc", S_ORC,  1, 9, 6, 0, -3, (G_GENO | G_NOGEN | G_LGROUP),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG, C(RED) },
	{ "hill orc", S_ORC, 2, 9, 6, 0, -4, (G_GENO | G_LGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG, C(YELLOW) },
#ifdef TOLKIEN
	{ "Mordor orc", S_ORC, 3, 5, 6, 0, -5, (G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG, C(BLUE) },
	{ "Uruk-hai", S_ORC, 3, 7, 5, 0, -4, (G_GENO | G_LGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG, C(BLACK) },
#endif
	{ "orc shaman", S_ORC, 3, 9, 5, 10, -5, (G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_MAGIC,
	  M2_ORC | M2_HOSTILE | M2_STRONG, C(HI_ZAP) },
	{ "orc-captain", S_ORC, 5, 5, 4, 0, -5, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_ORC, MZ_HUMAN,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_ORC | M2_HOSTILE | M2_STRONG, C(HI_LORD) },
/*	 piercers	*/
	{ "rock piercer", S_PIERCER, 3, 1, 3, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, MZ_SMALL,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_CARNIVORE, C(GRAY) },
	{ "iron piercer", S_PIERCER, 5, 1, 0, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 300, 0, MS_SILENT, MZ_MEDIUM,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_CARNIVORE, C(CYAN) },
/*	quadrupeds (generic)	*/
	{ "rothe", S_QUADRUPED, 2, 9, 7, 0, 0, (G_GENO | G_SGROUP | 4),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(GRAY) },
#ifdef TOLKIEN
	{ "mumakil", S_QUADRUPED, 5, 9, 0, 0, -2, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 4, 12 }, { AT_BITE, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 500, 0, MS_SILENT, MZ_LARGE,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(GRAY) },
#endif
	{ "leocrotta", S_QUADRUPED, 6, 18, 4, 10, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_BITE, AD_PHYS, 2, 6 },
	    { AT_CLAW, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_IMITATE, MZ_LARGE, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(RED) },
	{ "wumpus", S_QUADRUPED, 8, 3, 2, 10, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(CYAN) },
	{ "titanothere", S_QUADRUPED, 12, 12, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  65, 650, 0, MS_SILENT, MZ_LARGE,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(GRAY) },
	{ "baluchitherium", S_QUADRUPED, 14, 12, 5, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 5, 4 }, { AT_CLAW, AD_PHYS, 5, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  80, 800, 0, MS_SILENT, MZ_LARGE,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS,
	  M2_HOSTILE | M2_STRONG | M2_HERBIVORE, C(GRAY) },
/*	rodents 	*/
	{ "sewer rat",	S_RODENT, 0, 12, 7, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SQEEK, MZ_TINY, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "giant rat",	S_RODENT, 1, 10, 7, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SQEEK, MZ_TINY, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "rabid rat", S_RODENT, 2, 12, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRCO, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 10, 0, MS_SQEEK, MZ_TINY, M1_ANIMAL | M1_NOHANDS | M1_POIS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "ratwere", S_RODENT, 2, 12, 6, 10, -7, G_NOGEN | G_NOCORPSE,
	  { { AT_BITE, AD_WERE, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SQEEK, MZ_TINY, M1_NOHANDS | M1_NOPOLY |
	  M1_POIS | M1_REGEN, M2_WERE | M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "rock mole", S_RODENT, 3, 3, 0, 20, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, MZ_SMALL,
	  M1_TUNNEL | M1_ANIMAL | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_COLLECT, M2_HOSTILE | M2_METALLIVORE, C(GRAY) },
/*	spiders and scorpions	*/
	{ "cave spider", S_SPIDER, 1, 12, 3, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 50, 0, MS_SILENT, MZ_TINY,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(GRAY) },
	{ "scorpion", S_SPIDER, 5, 15, 3, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    { AT_STNG, AD_DRST, 1, 4 }, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_SMALL,
	  M1_CONCEAL | M1_ANIMAL | M1_NOHANDS | M1_POIS,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(RED) },
	{ "giant spider", S_SPIDER, 5, 15, 4, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_LARGE,
	  M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_EGGS, C(MAGENTA) },
/*	trappers, lurkers, &c.	*/
	{ "lurker above", S_TRAPPER, 10, 3, 3, 0, 0, (G_GENO | 2),
	  { { AT_ENGL, AD_DGST, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 350, 0, MS_SILENT, MZ_HUGE,
	  M1_HIDE | M1_FLY | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_STALK | M2_STRONG | M2_CARNIVORE, C(GRAY) },
	{ "trapper", S_TRAPPER, 12, 3, 3, 0, 0, (G_GENO | 2),
	  { { AT_ENGL, AD_DGST, 1, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 350, 0, MS_SILENT, MZ_HUGE,
	  M1_HIDE | M1_ANIMAL | M1_NOEYES | M1_NOLIMBS,
	  M2_HOSTILE | M2_STALK | M2_STRONG | M2_CARNIVORE, C(GREEN) },
/*	unicorns	*/
	{ "white unicorn", S_UNICORN, 4, 24, 2, 70, 7, (G_GENO | 2),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_NEIGH, MZ_LARGE, M1_NOHANDS | M1_POIS_RES | M1_JEWELS,
	  M2_WANDER | M2_STRONG | M2_HERBIVORE, C(WHITE) },
	{ "gray unicorn", S_UNICORN, 4, 24, 2, 70, 0, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_NEIGH, MZ_LARGE, M1_NOHANDS | M1_POIS_RES | M1_JEWELS,
	  M2_WANDER | M2_STRONG | M2_HERBIVORE, C(GRAY) },
	{ "black unicorn", S_UNICORN, 4, 24, 2, 70, -7, (G_GENO | 1),
	  { { AT_BUTT, AD_PHYS, 1, 12 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_NEIGH, MZ_LARGE, M1_NOHANDS | M1_POIS_RES | M1_JEWELS,
	  M2_WANDER | M2_STRONG | M2_HERBIVORE, C(BLACK) },
/*	vortices	*/
	{ "fog cloud",	S_VORTEX, 3,  1, 0, 0, 0, (G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES,
	  M2_HOSTILE, C(GRAY) },
	{ "dust vortex", S_VORTEX, 4, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_BLND, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES, M2_HOSTILE, C(BROWN) },
	{ "energy vortex", S_VORTEX, 6, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_ENGL, AD_ELEC, 1, 6 }, { AT_ENGL, AD_DREN, 0, 0 },
	    { AT_NONE, AD_ELEC, 0, 4 }, NO_ATTK, NO_ATTK },
	  20, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_ELEC_RES,
	  M2_HOSTILE, C(HI_ZAP) },
	{ "ice vortex", S_VORTEX, 5, 20, 2, 30, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_ENGL, AD_COLD, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_COLD_RES,
	  M2_HOSTILE, C(CYAN) },
	{ "steam vortex", S_VORTEX, 7, 22, 2, 30, 0,
	  (G_HELL | G_GENO | G_NOCORPSE | 2),
	  { { AT_ENGL, AD_FIRE, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_FIRE_RES,
	  M2_HOSTILE, C(BLUE) },
	{ "fire vortex", S_VORTEX, 8, 22, 2, 30, 0,
	  (G_HELL | G_GENO | G_NOCORPSE | 1),
	  { { AT_ENGL, AD_FIRE, 1, 10 }, { AT_NONE, AD_FIRE, 0, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_FIRE_RES,
	  M2_HOSTILE, C(YELLOW) },
/*	worms	*/
#ifdef WORM
	{ "baby long worm", S_WORM, 8, 3, 5, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_SLITHY | M1_NOLIMBS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
#endif
	{ "baby purple worm", S_WORM, 8, 3, 5, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  25, 250, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_SLITHY | M1_NOLIMBS,
	  M2_HOSTILE | M2_CARNIVORE, C(MAGENTA) },
#ifdef WORM
	{ "long worm", S_WORM, 8, 3, 5, 10, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_GIGANTIC,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_NOPOLY,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(BROWN) },
#endif
	{ "purple worm", S_WORM, 15, 9, 6, 20, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 2, 8 }, { AT_ENGL, AD_DGST, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 70, 700, 0, MS_SILENT, MZ_GIGANTIC,
	  M1_ANIMAL | M1_SLITHY | M1_NOLIMBS,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(MAGENTA) },
/*	xan, &c.	*/
	{ "grid bug", S_XAN, 0, 12, 9, 0, 0,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 3),
	  { { AT_BITE, AD_ELEC, 1, 1 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 50, 0, MS_BUZZ, MZ_TINY, M1_ANIMAL | M1_ELEC_RES, M2_HOSTILE,
	  C(MAGENTA) },
	{ "xan", S_XAN, 7, 18, -4, 0, 0, (G_GENO | 3),
	  { { AT_STNG, AD_LEGS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 300, 0, MS_BUZZ, MZ_TINY, M1_FLY | M1_ANIMAL | M1_NOHANDS |
	  M1_POIS | M1_POIS_RES, M2_HOSTILE, C(RED) },
/*	yellow light	*/
	{ "yellow light", S_YLIGHT,  3, 15, 0, 0, 0, (G_GENO | 4),
	  { { AT_EXPL, AD_BLND, 10, 20 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 10, 0, MS_SILENT, MZ_SMALL,
	  M1_FLY | M1_NOLIMBS, M2_HOSTILE, C(BRIGHT|YELLOW) },
/*	zruty	*/
	{ "zruty", S_ZRUTY, 9, 8, 3, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 3, 6 }, NO_ATTK, NO_ATTK },
	  60, 600, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(BROWN) },
/*	Apes	*/
	{ "ape", S_APE, 4, 12, 6, 0, 0, (G_GENO | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_GROWL, MZ_LARGE, M1_ANIMAL | M1_HUMANOID,
	  M2_STRONG | M2_CARNIVORE, C(BROWN) },
	{ "carnivorous ape", S_APE, 5, 12, 6, 0, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_HUGS, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK },
	  55, 550, 0, MS_GROWL, MZ_LARGE, M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(BROWN) },
/*	Bats	*/
	{ "bat", S_BAT, 0, 22, 8, 0, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SQEEK, MZ_TINY, M1_FLY | M1_ANIMAL | M1_NOHANDS,
	  M2_WANDER | M2_CARNIVORE, C(BROWN) },
	{ "giant bat", S_BAT, 2, 22, 7, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SQEEK, MZ_MEDIUM, M1_FLY | M1_ANIMAL | M1_NOHANDS,
	  M2_WANDER | M2_HOSTILE | M2_CARNIVORE, C(RED) },
	{ "vampire bat", S_BAT, 5, 20, 6, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRST, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 20, 0, MS_SQEEK, MZ_TINY,
	  M1_FLY | M1_ANIMAL | M1_NOHANDS | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_HOSTILE, C(BLACK) },
/*	Centaurs	*/
	{ "plains centaur", S_CENTAUR, 4, 18, 4, 0, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK},
	  50, 500, 0, MS_SILENT, MZ_LARGE, M1_COLLECT | M1_GREEDY, M2_STRONG,
	  C(BROWN)  },
	{ "forest centaur", S_CENTAUR, 5, 18, 3, 10, -1, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_KICK, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK},
	  55, 600, 0, MS_SILENT, MZ_LARGE, M1_COLLECT | M1_GREEDY, M2_STRONG,
	  C(GREEN)  },
	{ "mountain centaur", S_CENTAUR, 6, 20, 2, 10, -3, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 10 }, { AT_KICK, AD_PHYS, 1, 6 },
	    { AT_KICK, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK },
	  55, 500, 0, MS_SILENT, MZ_LARGE, M1_COLLECT | M1_GREEDY, M2_STRONG,
	  C(CYAN) },
/*	Dragons 	*/
	{ "baby gray dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(GRAY) },
	{ "baby red dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(RED) },
	{ "baby white dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(WHITE) },
	{ "baby blue dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_ELEC_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(BLUE) },
	{ "baby green dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(GREEN) },
	{ "baby orange dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_SLEE_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(ORANGE_COLORED) },
	{ "baby black dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(BLACK) },
	{ "baby yellow dragon", S_DRAGON, 12, 9, 2, 10, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_ROAR, MZ_HUGE,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_ACID | M1_STON_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(YELLOW) },
	{ "gray dragon", S_DRAGON, 10, 9, -1, 20, 4, (G_GENO | 1),
	  { { AT_BREA, AD_MAGM, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS, C(GRAY) },
	{ "red dragon", S_DRAGON, 10, 9, -1, 20, -4, (G_GENO | 1),
	  { { AT_BREA, AD_FIRE, 6, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS | M1_FIRE_RES,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS, C(RED) },
	{ "orange dragon", S_DRAGON, 10, 9, -1, 20, 5, (G_GENO | 1),
	  { { AT_BREA, AD_SLEE, 4, 25 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS | M1_SLEE_RES,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(ORANGE_COLORED) },
	{ "white dragon", S_DRAGON, 10, 9, -1, 20, -5, (G_GENO | 1),
	  { { AT_BREA, AD_COLD, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS | M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(WHITE) },
	{ "black dragon", S_DRAGON, 10, 9, -1, 20, -6, (G_GENO | 1),
	  { { AT_BREA, AD_DISN, 4, 10 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(BLACK) },
	{ "blue dragon", S_DRAGON, 10, 9, -1, 20, -7, (G_GENO | 1),
	  { { AT_BREA, AD_ELEC, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS | M1_ELEC_RES,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(BLUE) },
	{ "green dragon", S_DRAGON, 10, 9, -1, 20, 6, (G_GENO | 1),
	  { { AT_BREA, AD_DRST, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(GREEN) },
	{ "yellow dragon", S_DRAGON, 10, 9, -1, 20, 7, (G_GENO | 1),
	  { { AT_BREA, AD_ACID, 4, 6 }, { AT_BITE, AD_PHYS, 3, 8 },
	    { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK },
	  150, 1500, 0, MS_ROAR, MZ_GIGANTIC,
	  M1_FLY | M1_THICK_HIDE | M1_NOHANDS | M1_GREEDY | M1_JEWELS |
	  M1_MAGIC | M1_SEE_INVIS | M1_ACID | M1_STON_RES,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE | M2_EGGS,
	  C(YELLOW) },
/*	Elementals	*/
	{ "air elemental", S_ELEMENTAL, 8, 36, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_ENGL, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES, M2_STRONG, C(CYAN) },
	{ "fire elemental", S_ELEMENTAL, 8, 12, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_FIRE, 3, 6 }, { AT_NONE, AD_FIRE, 0, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_FLY | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_FIRE_RES,
	  M2_STRONG, C(YELLOW) },
	{ "earth elemental", S_ELEMENTAL, 8, 6, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 4, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_WALLWALK | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_THICK_HIDE |
	  M1_STON_RES,
	  M2_STRONG, C(BROWN) },
	{ "water elemental", S_ELEMENTAL, 8, 6, 2, 30, 0, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 5, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 0, 0, MS_SILENT, MZ_HUGE,
	  M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_SWIM, M2_STRONG, C(BLUE) },
/*	Fungi	*/
	{ "violet fungus", S_FUNGUS, 3, 1, 7, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_PHYS, 1, 4 }, { AT_TUCH, AD_STCK, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 10, 100, 0, MS_SILENT, MZ_SMALL,
	  M1_NOEYES | M1_NOLIMBS | M1_POIS_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(MAGENTA) },
	{ "brown mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 1),
	  { { AT_NONE, AD_COLD, 0, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, MZ_SMALL,
	  M1_NOEYES | M1_NOLIMBS | M1_COLD_RES | M1_POIS_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(BROWN) },
	{ "yellow mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 2),
	  { { AT_NONE, AD_STUN, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, MZ_SMALL,
	  M1_NOEYES | M1_NOLIMBS | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(YELLOW) },
	{ "green mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 1),
	  { { AT_NONE, AD_ACID, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, MZ_SMALL,
	  M1_NOEYES | M1_NOLIMBS | M1_ACID | M1_STON_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(GREEN) },
	{ "red mold", S_FUNGUS, 1, 0, 9, 0, 0, (G_GENO | 1),
	  { { AT_NONE, AD_FIRE, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 30, 0, MS_SILENT, MZ_SMALL,
	  M1_NOEYES | M1_NOLIMBS | M1_FIRE_RES | M1_POIS_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(RED) },
/*	Gnomes	*/
	{ "gnome", S_GNOME, 1, 6, 5, 4, 0, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_ORC, MZ_SMALL,
	  M1_HUMANOID | M1_COLLECT, 0, C(BROWN) },
	{ "gnome lord", S_GNOME, 3, 8, 4, 4, 0, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 120, 0, MS_ORC, MZ_SMALL,
	  M1_HUMANOID | M1_COLLECT, M2_LORD, C(BLUE) },
	{ "gnome king", S_GNOME, 5, 10, 2, 20, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 150, 0, MS_ORC, MZ_SMALL,
	  M1_HUMANOID | M1_COLLECT, M2_PRINCE, C(HI_LORD) },
	{ "gnomish wizard", S_GNOME, 3, 10, 4, 10, 0, (G_GENO | 1),
	  { { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 120, 0, MS_ORC, MZ_SMALL,
	  M1_HUMANOID | M1_MAGIC, 0, C(HI_ZAP) },
#ifdef SPLITMON_1
};
#endif
#endif /* !SPLITMON_2 */

/* horrible kludge alert:
 * This is a compiler-specific kludge to allow the compilation of monst.o in
 * two pieces, by defining first SPLITMON_1 and then SPLITMON_2. The
 * resulting assembler files (monst1.s and monst2.s) are then run through
 * sed to change local symbols, concatenated together, and assembled to
 * produce monst.o. THIS ONLY WORKS WITH THE ATARI GCC, and should only
 * be done if you don't have enough memory to compile monst.o the "normal"
 * way.  --ERS
 */

#ifndef SPLITMON_1
#ifdef SPLITMON_2
struct permonst _mons2[] = {
#endif
/*	giant Humanoids */
	{ "ettin", S_GIANT, 10, 12, 3, 0, 0, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_GRUNT, MZ_HUGE, M1_ANIMAL | M1_HUMANOID | M1_COLLECT,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE, C(BROWN) },
	{ "giant", S_GIANT, 6, 6, 0, 0, 2, (G_GENO | G_NOGEN | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT, MZ_HUGE, M1_HUMANOID | M1_COLLECT | M1_JEWELS,
	   M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY, C(RED) },
	{ "stone giant", S_GIANT, 6, 6, 0, 0, 2, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT, MZ_HUGE, M1_HUMANOID | M1_COLLECT | M1_JEWELS,
	   M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY, C(GRAY) },
	{ "hill giant", S_GIANT, 8, 10, 6, 0, -2, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_SILENT, MZ_HUGE, M1_HUMANOID | M1_COLLECT | M1_JEWELS,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY, C(CYAN) },
	{ "fire giant", S_GIANT, 9, 12, 4, 5, 2, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT, MZ_HUGE,
	  M1_HUMANOID | M1_FIRE_RES | M1_COLLECT | M1_JEWELS,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY, C(YELLOW) },
	{ "frost giant", S_GIANT, 10, 12, 3, 10, -3, (G_GENO | G_SGROUP | 1),
	  { { AT_WEAP, AD_PHYS, 2, 12 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 750, 0, MS_SILENT, MZ_HUGE,
	  M1_HUMANOID | M1_COLD_RES | M1_COLLECT | M1_JEWELS,
	  M2_GIANT | M2_STRONG | M2_ROCKTHROW | M2_NASTY, C(WHITE) },
	{ "titan", S_GIANT, 16, 18, -3, 70, 9, 1,
	  { { AT_WEAP, AD_PHYS, 2, 8 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  90, 900, 0, MS_SILENT, MZ_HUGE, M1_FLY | M1_HUMANOID | M1_MAGIC |
	  M1_COLLECT, M2_STRONG | M2_ROCKTHROW | M2_NASTY, C(MAGENTA) },
	{ "minotaur", S_GIANT, 15, 15, 6, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 3, 10 }, { AT_CLAW, AD_PHYS, 3, 10 },
	    { AT_BUTT, AD_PHYS, 2, 8}, NO_ATTK, NO_ATTK},
	  70, 700, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE, C(BROWN) },
	{ "owlbear", S_GIANT, 5, 12, 5, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_HUGS, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_HUMANOID,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE, C(BROWN) },
/*	Invisible stalker	*/
	{ "stalker", S_STALKER, 8, 12, 3, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT, MZ_LARGE, M1_ANIMAL | M1_FLY | M1_SEE_INVIS,
	  M2_WANDER | M2_STALK | M2_HOSTILE | M2_STRONG, C(WHITE) },
/*	Jabberwock */
	{ "jabberwock", S_JABBERWOCK, 15, 12, -2, 50, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 10 }, { AT_BITE, AD_PHYS, 2, 10 },
	    { AT_CLAW, AD_PHYS, 2, 10 }, { AT_CLAW, AD_PHYS, 2, 10 }, NO_ATTK },
	  60, 600, 0, MS_BURBLE, MZ_LARGE, M1_ANIMAL | M1_COLLECT | M1_FLY,
	  M2_HOSTILE | M2_STRONG | M2_NASTY | M2_CARNIVORE, C(BRIGHT|RED) },
/*	Kops	*/
#ifdef KOPS
	{ "Keystone Kop", S_KOP, 1, 6, 7, 10, 9, (G_GENO | G_LGROUP | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, MZ_HUMAN, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE, C(BLUE) },
	{ "Kop Sergeant", S_KOP, 2, 8, 6, 10, 10, (G_GENO | G_SGROUP | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, MZ_HUMAN, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG, C(BLUE) },
	{ "Kop Lieutenant", S_KOP, 3, 10, 5, 20, 11, (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, MZ_HUMAN, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG, C(CYAN) },
	{ "Kop Kaptain", S_KOP, 4, 12, 4, 20, 12, (G_GENO | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_ARREST, MZ_HUMAN, M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_WANDER | M2_HOSTILE | M2_STRONG, C(HI_LORD) },
#endif
/*	Liches	 */
	{ "lich", S_LICH, 11, 6, 0, 30, -9, (G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 1, 10 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_COLD_RES | M1_REGEN | M1_MAGIC,
	  M2_UNDEAD | M2_HOSTILE, C(BROWN) },
	{ "demilich", S_LICH, 14, 9, -2, 60, -12, (G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 3, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_COLD_RES | M1_REGEN | M1_MAGIC,
	  M2_UNDEAD | M2_HOSTILE, C(RED) },
	{ "master lich", S_LICH, 17, 9, -4, 90, -15, (G_HELL | G_GENO | 1),
	  { { AT_TUCH, AD_COLD, 3, 6 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 100, 0, MS_MUMBLE, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_COLD_RES | M1_REGEN |
	  M1_MAGIC, M2_UNDEAD | M2_HOSTILE, C(HI_LORD) },
/*	Mummies 	*/
	{ "kobold mummy", S_MUMMY, 3, 8, 6, 20, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_SMALL,
	  M1_HUMANOID | M1_POIS, M2_UNDEAD | M2_HOSTILE, C(BROWN) },
	{ "gnome mummy", S_MUMMY, 4, 10, 6, 20, -3, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_SMALL,
	  M1_HUMANOID | M1_POIS, M2_UNDEAD | M2_HOSTILE, C(RED) },
	{ "orc mummy", S_MUMMY, 5, 10, 5, 20, -4, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_GREEDY | M1_JEWELS,
	  M2_UNDEAD | M2_HOSTILE | M2_ORC, C(GRAY) },
	{ "elf mummy", S_MUMMY, 6, 12, 4, 30, -5, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_SLEE_RES,
	  M2_UNDEAD | M2_HOSTILE | M2_ELF, C(GREEN) },
	{ "human mummy", S_MUMMY, 6, 12, 4, 30, -5, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS, M2_UNDEAD | M2_HOSTILE, C(GRAY) },
	{ "ettin mummy", S_MUMMY, 7, 12, 4, 30, -6, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_PHYS, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_SILENT, MZ_HUGE,
	  M1_HUMANOID | M1_POIS,
	  M2_UNDEAD | M2_HOSTILE | M2_STRONG, C(BLUE) },
	{ "giant mummy", S_MUMMY, 8, 14, 3, 30, -7, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 75, 750, 0, MS_SILENT, MZ_HUGE,
	  M1_HUMANOID | M1_POIS | M1_JEWELS,
	  M2_UNDEAD | M2_HOSTILE | M2_GIANT | M2_STRONG, C(CYAN) },
/*	Nagas	*/
	{ "red naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, MZ_LARGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_FIRE_RES | M1_POIS_RES,
	  M2_STRONG, C(RED) },
	{ "black naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, MZ_LARGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES | M1_STON_RES,
	  M2_STRONG, C(BLACK) },
	{ "golden naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, MZ_LARGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES,
	  M2_STRONG, C(HI_GOLD) },
	{ "guardian naga hatchling", S_NAGA, 3, 10, 6, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 100, 0, MS_MUMBLE, MZ_LARGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES,
	  M2_STRONG, C(GREEN) },
	{ "red naga", S_NAGA, 6, 12, 4, 0, -4, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 4 }, { AT_BREA, AD_FIRE, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 60, 400, 0, MS_MUMBLE, MZ_HUGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES | M1_FIRE_RES,
	  M2_STRONG | M2_EGGS, C(RED) },
	{ "black naga", S_NAGA, 8, 14, 2, 10, 4, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_SPIT, AD_ACID, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 60, 400, 0, MS_MUMBLE, MZ_HUGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES |
	  M1_ACID | M1_STON_RES,
	  M2_STRONG | M2_EGGS, C(BLACK) },
	{ "golden naga", S_NAGA, 10, 14, 2, 70, 5, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 2, 6 }, { AT_MAGC, AD_SPEL, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 60, 400, 0, MS_MUMBLE, MZ_HUGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES,
	  M2_STRONG | M2_EGGS, C(HI_GOLD) },
	{ "guardian naga", S_NAGA, 12, 16, 0, 50, 7, (G_GENO | 1),
	  { { AT_BITE, AD_PLYS, 1, 6 }, { AT_HUGS, AD_PHYS, 2, 4 },
	    { AT_SPIT, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK },
	  60, 400, 0, MS_MUMBLE, MZ_HUGE,
	  M1_NOLIMBS | M1_SLITHY | M1_THICK_HIDE | M1_POIS_RES | M1_POIS,
	  M2_STRONG | M2_EGGS, C(GREEN) },
/*	Ogres	*/
	{ "ogre", S_OGRE, 5, 10, 5, 0, -3, (G_SGROUP | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 5 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  60, 500, 0, MS_GRUNT, MZ_LARGE,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_STRONG, C(BROWN) },
	{ "ogre lord", S_OGRE, 7, 12, 3, 30, -5, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_GRUNT, MZ_LARGE,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_STRONG | M2_LORD, C(RED) },
	{ "ogre king", S_OGRE, 7, 14, 4, 60, -7, (G_GENO | 2),
	  { { AT_WEAP, AD_PHYS, 3, 5 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  70, 750, 0, MS_GRUNT, MZ_LARGE,
	  M1_HUMANOID | M1_GREEDY | M1_JEWELS | M1_COLLECT,
	  M2_STRONG | M2_PRINCE, C(HI_LORD) },
/*	Puddings */
	{ "gray ooze", S_PUDDING, 3, 1, 8, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_RUST, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_MEDIUM,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES,
	  M2_HOSTILE | M2_OMNIVORE, C(GRAY) },
	{ "brown pudding", S_PUDDING, 5, 3, 8, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DCAY, 0, 0 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_MEDIUM,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_COLD_RES |
	  M1_ELEC_RES, M2_HOSTILE | M2_OMNIVORE, C(BROWN) },
	{ "black pudding", S_PUDDING, 10, 6, 6, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_RUST, 3, 8 }, { AT_NONE, AD_RUST, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_LARGE,
	  M1_AMORPHOUS | M1_NOEYES | M1_NOLIMBS | M1_POIS_RES | M1_COLD_RES |
	  M1_ELEC_RES, M2_HOSTILE | M2_OMNIVORE, C(BLACK) },
/*	Quantum Mechanics	*/
	{ "quantum mechanic", S_QUANTMECH, 7, 12, 3, 10, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_TLPT, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_TPORT, M2_HOSTILE, C(CYAN) },
/*	Rust Monster	*/
	{ "rust monster", S_RUSTMONST, 5, 18, 2, 0, 0, (G_GENO | 2),
	  { { AT_TUCH, AD_RUST, 0, 0 }, { AT_TUCH, AD_RUST, 0, 0 },
	    { AT_NONE, AD_RUST, 0, 0 }, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_MEDIUM,
	  M1_SWIM | M1_ANIMAL | M1_NOHANDS, M2_HOSTILE | M2_METALLIVORE,
	  C(BROWN) },
/*	Snakes	*/
	{ "garter snake", S_SNAKE, 1, 8, 8, 0, 0, (G_LGROUP | G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  5, 60, 0, MS_HISS, MZ_TINY,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY,
	  M2_CARNIVORE | M2_EGGS, C(GREEN) },
	{ "snake", S_SNAKE, 4, 15, 3, 0, 0, (G_GENO | 2),
	  { { AT_BITE, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 80, 0, MS_HISS, MZ_SMALL,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY |
	  M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BROWN) },
	{ "water moccasin", S_SNAKE, 4, 15, 3, 0, 0,
	  (G_GENO | G_NOGEN | G_LGROUP),
	  { { AT_BITE, AD_DRST, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_HISS, MZ_SMALL,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY |
	  M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(RED) },
	{ "pit viper", S_SNAKE, 6, 15, 2, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, { AT_BITE, AD_DRST, 1, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 5, 60, 0, MS_HISS, MZ_MEDIUM,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY |
	  M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BLUE) },
	{ "cobra", S_SNAKE, 6, 18, 2, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 2, 4 }, { AT_SPIT, AD_BLND, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 15, 100, 0, MS_HISS, MZ_MEDIUM,
	  M1_SWIM | M1_CONCEAL | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY |
	  M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BLUE) },
	{ "python", S_SNAKE, 6, 3, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_DRST, 1, 4 }, { AT_HUGS, AD_WRAP, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 15, 100, 0, MS_HISS, MZ_LARGE,
	  M1_SWIM | M1_NOLIMBS | M1_ANIMAL | M1_SLITHY | M1_POIS | M1_POIS_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE | M2_EGGS, C(MAGENTA) },
/*	Trolls	*/
	{ "troll", S_TROLL, 7, 12, 4, 0, -3, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 4, 2 }, { AT_CLAW, AD_PHYS, 4, 2 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_GRUNT, MZ_LARGE, M1_HUMANOID | M1_REGEN,
	  M2_STRONG | M2_STALK | M2_CARNIVORE | M2_HOSTILE, C(BROWN) },
	{ "ice troll", S_TROLL, 9, 10, 2, 20, -3, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 6 }, { AT_CLAW, AD_COLD, 2, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 300, 0, MS_GRUNT, MZ_LARGE,
	  M1_HUMANOID | M1_COLD_RES | M1_REGEN,
	  M2_STRONG | M2_STALK | M2_CARNIVORE | M2_HOSTILE, C(WHITE) },
	{ "rock troll", S_TROLL, 9, 12, 0, 0, -3, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 300, 0, MS_GRUNT, MZ_LARGE,
	  M1_HUMANOID | M1_REGEN | M1_COLLECT,
	  M2_STRONG | M2_STALK | M2_CARNIVORE | M2_HOSTILE, C(CYAN) },
	{ "water troll", S_TROLL, 11, 14, 4, 40, -3, (G_NOGEN | G_GENO),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_GRUNT, MZ_LARGE,
	  M1_SWIM | M1_HUMANOID | M1_REGEN,
	  M2_STRONG | M2_STALK | M2_CARNIVORE | M2_HOSTILE, C(BLUE) },
#ifdef TOLKIEN
	{ "Olog-hai", S_TROLL, 13, 12, -4, 0, -7, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_BITE, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_GRUNT, MZ_LARGE,
	  M1_HUMANOID | M1_REGEN | M1_COLLECT,
	  M2_STRONG | M2_STALK | M2_CARNIVORE | M2_HOSTILE, C(HI_LORD) },
#endif
/*	Umber Hulk	*/
	{ "umber hulk", S_UMBER, 9, 6, 2, 25, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_BITE, AD_PHYS, 2, 5 }, { AT_GAZE, AD_CONF, 0, 0 }, NO_ATTK },
	  50, 500, 0, MS_SILENT, MZ_LARGE,
	  M1_TUNNEL, M2_STRONG | M2_CARNIVORE, C(BROWN) },
/*	Vampires	*/
	{ "vampire", S_VAMPIRE, 10, 12, 1, 25, -8, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRLI, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 400, 0, MS_VAMPIRE, MZ_HUMAN,
	  M1_FLY | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY, C(RED) },
	{ "vampire lord", S_VAMPIRE, 12, 14, 0, 50, -9, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 8 }, { AT_BITE, AD_DRLI, 1, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 400, 0, MS_VAMPIRE, MZ_HUMAN,
	  M1_FLY | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY | M2_LORD,
	  C(BLUE) },
	{ "Vlad the Impaler", S_VAMPIRE, 14, 18, -3, 80, -10,
	  (G_NOGEN | G_NOCORPSE | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 6 }, { AT_BITE, AD_DRLI, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 400, 0, MS_VAMPIRE, MZ_HUMAN,
	  M1_NOPOLY | M1_FLY | M1_HUMANOID | M1_POIS | M1_REGEN,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY |
	  M2_PRINCE, C(HI_LORD) },
/*	Wraiths 	*/
	{ "barrow wight", S_WRAITH, 3, 12, 5, 5, -3, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    { AT_WEAP, AD_DRLI, 0, 0 }, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT, MZ_HUMAN, M1_HUMANOID | M1_POIS_RES | M1_COLLECT,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, C(GRAY) },
	{ "wraith", S_WRAITH, 6, 12, 4, 15, -6, (G_GENO | 2),
	  { { AT_TUCH, AD_DRLI, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  30, 0, 0, MS_SILENT, MZ_HUMAN,
	  M1_FLY | M1_HUMANOID | M1_POIS_RES,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, C(BLACK) },
#ifdef TOLKIEN
	{ "Nazgul", S_WRAITH, 13, 12, 0, 25, -17, (G_GENO | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_DRLI, 1, 4 }, { AT_BREA, AD_SLEE, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 30, 0, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS_RES | M1_COLLECT,
	  M2_UNDEAD | M2_STALK | M2_STRONG | M2_HOSTILE, C(HI_LORD) },
#endif
/*	Xorn	*/
	{ "xorn", S_XORN, 8, 9,-2, 20, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, { AT_BITE, AD_PHYS, 4, 6 },
	    NO_ATTK }, 70, 700, 0, MS_SILENT, MZ_MEDIUM,
	  M1_WALLWALK | M1_THICK_HIDE | M1_FIRE_RES | M1_COLD_RES |
	  M1_STON_RES, M2_HOSTILE | M2_STRONG, C(BROWN) },
/*	Yeti	*/
	{ "yeti", S_YETI, 5, 15, 6, 0, 0, (G_GENO | 2),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  70, 700, 0, MS_GROWL, MZ_LARGE, M1_ANIMAL | M1_HUMANOID | M1_COLD_RES,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(WHITE) },
/*	Zombies 	*/
	{ "kobold zombie", S_ZOMBIE, 0, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_SMALL, M1_HUMANOID | M1_POIS |
	  M1_POIS_RES, M2_UNDEAD | M2_STALK | M2_HOSTILE, C(BROWN) },
	{ "gnome zombie", S_ZOMBIE, 1, 6, 10, 0, -2, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 5 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_SMALL, M1_HUMANOID | M1_POIS |
	  M1_POIS_RES, M2_UNDEAD | M2_STALK | M2_HOSTILE, C(BROWN) },
	{ "orc zombie", S_ZOMBIE, 2, 6, 9, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  15, 150, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS_RES | M1_GREEDY |
	  M1_JEWELS, M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_ORC, C(GRAY) },
	{ "elf zombie", S_ZOMBIE, 3, 6, 9, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 7 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS_RES | M1_SLEE_RES,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_ELF, C(GREEN) },
	{ "human zombie", S_ZOMBIE, 4, 6, 8, 0, -3,
	  (G_GENO | G_SGROUP | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS_RES,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, C(HI_DOMESTIC) },
	{ "ettin zombie", S_ZOMBIE, 6, 8, 6, 0, -4, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 10 }, { AT_CLAW, AD_PHYS, 1, 10 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_SILENT, MZ_HUGE,
	  M1_HUMANOID | M1_POIS_RES,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_STRONG, C(BLUE) },
	{ "giant zombie", S_ZOMBIE, 8, 8, 6, 0, -4, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 75, 750, 0, MS_SILENT, MZ_HUGE,
	  M1_HUMANOID | M1_POIS_RES | M1_JEWELS,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE | M2_GIANT | M2_STRONG, C(CYAN) },
/*	Golems	*/
#ifdef GOLEMS
	{ "straw golem", S_GOLEM, 3, 12, 10, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 2 }, { AT_CLAW, AD_PHYS, 1, 2 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 10, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES, M2_HOSTILE, C(YELLOW) },
	{ "rope golem", S_GOLEM, 4, 9, 8, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_HUGS, AD_PHYS, 6, 1 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 20, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES, M2_HOSTILE, C(BROWN) },
	{ "leather golem", S_GOLEM, 6, 6, 6, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 6 }, { AT_CLAW, AD_PHYS, 1, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 40, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES, M2_HOSTILE, C(HI_LEATHER) },
	{ "wood golem", S_GOLEM, 7, 3, 4, 0, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  50, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES | M1_THICK_HIDE, M2_HOSTILE, C(HI_WOOD) },
	{ "flesh golem", S_GOLEM, 9, 8, 9, 30, 0, (G_GENO | 1),
	  { { AT_CLAW, AD_PHYS, 2, 8 }, { AT_CLAW, AD_PHYS, 2, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK},
	  60, 600, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES | M1_FIRE_RES | M1_COLD_RES | M1_ELEC_RES,
	  M2_HOSTILE | M2_STRONG, C(RED) },
	{ "clay golem", S_GOLEM, 11, 7, 7, 40, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  75, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES | M1_THICK_HIDE,
	  M2_HOSTILE | M2_STRONG, C(BROWN) },
	{ "stone golem", S_GOLEM, 14, 6, 5, 50, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 3, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  90, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS_RES | M1_THICK_HIDE | M1_STON_RES,
	  M2_HOSTILE | M2_STRONG, C(GRAY) },
	{ "iron golem", S_GOLEM, 18, 6, 3, 60, 0, (G_GENO | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_BREA, AD_DRST, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  100, 0, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_THICK_HIDE | M1_POIS | M1_FIRE_RES | M1_COLD_RES |
	  M1_ELEC_RES | M1_COLLECT,
	  M2_HOSTILE | M2_STRONG, C(HI_METAL) },
#endif /* GOLEMS */
/*	Humans		*/
	{ "human", S_HUMAN, 0, 12, 10, 0, 0, G_NOGEN, /* for corpses */
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_PEACEFUL | M2_STRONG, C(HI_DOMESTIC) },
	{ "wererat", S_HUMAN, 2, 12, 7, 10, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SILENT, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_POIS | M1_REGEN | M1_COLLECT,
	  M2_WERE | M2_HOSTILE | M2_HUMAN, C(BROWN) },
	{ "werejackal", S_HUMAN, 2, 12, 7, 10, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_BARK, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_POIS | M1_REGEN | M1_COLLECT,
	  M2_WERE | M2_HOSTILE | M2_HUMAN, C(RED) },
	{ "werewolf", S_HUMAN, 5, 12, 6, 20, -7, 1,
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_BARK, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_POIS | M1_REGEN | M1_COLLECT,
	  M2_WERE | M2_HOSTILE | M2_HUMAN, C(ORANGE_COLORED) },
#ifdef TOLKIEN
	{ "Woodland-elf", S_HUMAN, 4, 12, 5, 10, 5, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, MZ_HUMAN, M1_HUMANOID |
	  M1_COLLECT | M1_SLEE_RES, M2_ELF, C(GREEN) },
	{ "Green-elf", S_HUMAN, 5, 12, 5, 10, 6, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, MZ_HUMAN, M1_HUMANOID |
	  M1_COLLECT | M1_SLEE_RES, M2_ELF, C(GREEN+BRIGHT) },
	{ "Grey-elf", S_HUMAN, 6, 12, 5, 10, 7, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, MZ_HUMAN, M1_HUMANOID |
	  M1_COLLECT | M1_SLEE_RES, M2_ELF, C(GRAY) },
#endif
	{ "elf-lord", S_HUMAN, 8, 12, 5, 20, 9, (G_GENO | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, MZ_HUMAN, M1_HUMANOID |
	  M1_COLLECT | M1_SLEE_RES, M2_ELF | M2_STRONG | M2_LORD, C(BLUE+BRIGHT) },
	{ "Elvenking", S_HUMAN, 9, 12, 5, 25, 10, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4},
	    NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_HUMANOID | M1_COLLECT | M1_SLEE_RES,
	  M2_ELF | M2_STRONG | M2_PRINCE, C(HI_LORD) },
	{ "nurse", S_HUMAN, 11, 6, 0, 0, 0, (G_GENO | 3),
	  { { AT_CLAW, AD_HEAL, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_NURSE, MZ_HUMAN, M1_NOPOLY | M1_HUMANOID | M1_POIS_RES,
	  M2_HUMAN | M2_HOSTILE, C(HI_DOMESTIC) },
	{ "shopkeeper", S_HUMAN, 12, 18, 0, 50, 0, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 4 }, { AT_WEAP, AD_PHYS, 4, 4 }, NO_ATTK,
	    NO_ATTK, NO_ATTK }, 45, 400, sizeof(struct eshk), MS_SELL, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_MAGIC | M1_COLLECT,
	  M2_HUMAN | M2_PEACEFUL | M2_STRONG, C(HI_DOMESTIC) },
	{ "guard", S_HUMAN, 12, 12, -1, 40, 10, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, sizeof(struct egd), MS_GUARD, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_PEACEFUL | M2_STRONG, C(BLUE) },
#ifdef ORACLE
	{ "oracle", S_HUMAN, 12, 0, 0, 50, 0, G_NOGEN | G_UNIQ,
	  { { AT_NONE, AD_MAGM, 0, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_ORACLE, MZ_HUMAN, M1_NOPOLY | M1_HUMANOID,
	  M2_HUMAN | M2_PEACEFUL | M2_FEM, C(HI_ZAP) },
#endif
#if defined(ALTARS) && defined(THEOLOGY)
	{ "temple priest", S_HUMAN, 12, 12, 0, 50, 1, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 1, 4 },
	    { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK, NO_ATTK },
	  45, 400, sizeof(struct epri), MS_PRIEST, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_ELEC_RES | M1_COLLECT,
	  M2_HUMAN | M2_PEACEFUL, C(WHITE) },
	{ "temple priestess", S_HUMAN, 12, 12, 0, 50, 1, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 4, 10 }, { AT_KICK, AD_PHYS, 1, 4 },
	    { AT_MAGC, AD_CLRC, 0, 0 }, NO_ATTK, NO_ATTK },
	  45, 400, sizeof(struct epri), MS_PRIEST, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_ELEC_RES | M1_COLLECT,
	  M2_HUMAN | M2_PEACEFUL | M2_FEM, C(WHITE) },
#endif
#ifdef ARMY
	{ "unarmored soldier", S_HUMAN, 6, 4, 10, 0, -2, G_NOGEN,
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG, C(BROWN) },
	{ "soldier", S_HUMAN, 6, 4, 3, 0, -2, (G_SGROUP | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG, C(GRAY) },
	{ "sergeant", S_HUMAN, 8, 4, 0, 5, -3, (G_SGROUP | G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 2, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG, C(RED) },
	{ "lieutenant", S_HUMAN, 10, 4, -2, 15, -4, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_WEAP, AD_PHYS, 3, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG, C(GREEN) },
	{ "captain", S_HUMAN, 12, 4, -3, 15, -5, (G_GENO | 1),
	  { { AT_WEAP, AD_PHYS, 4, 4 }, { AT_WEAP, AD_PHYS, 4, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, 0, MS_SOLDIER, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_MERC | M2_STALK | M2_HOSTILE | M2_STRONG, C(BLUE) },
#endif
#ifdef MEDUSA
	{ "Medusa", S_HUMAN, 20, 12, 2, 50, -15, G_NOGEN | G_UNIQ,
	  { { AT_CLAW, AD_PHYS, 1, 8 }, { AT_GAZE, AD_STON, 0, 0 },
	    { AT_BITE, AD_DRST, 1, 6 }, { AT_WEAP, AD_PHYS, 2, 4 }, NO_ATTK },
	  45, 400, 0, MS_HISS, MZ_LARGE,
	  M1_NOPOLY | M1_HUMANOID | M1_SLITHY | M1_POIS | M1_POIS_RES |
	  M1_STON_RES, M2_HOSTILE | M2_STRONG | M2_PNAME | M2_FEM,
	  C(BRIGHT|GREEN) },
#endif
	{ "Wizard of Yendor", S_HUMAN, 30, 12, -8, 100, -20, G_NOGEN,
	  { { AT_CLAW, AD_SAMU, 2, 12 }, { AT_MAGC, AD_SPEL, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, 0, MS_CUSS, MZ_HUMAN,
	  M1_NOPOLY | M1_FLY | M1_HUMANOID | M1_POIS_RES | M1_FIRE_RES |
	  M1_REGEN | M1_SEE_INVIS | M1_TPORT | M1_TPORT_CONTROL | M1_MAGIC,
	  M2_HUMAN | M2_PNAME | M2_HOSTILE | M2_STRONG | M2_NASTY | M2_PRINCE,
	  C(HI_LORD) },
#ifdef CHARON
	{ "Charon", S_HUMAN, 76, 18, -5, 120, 0,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 1, 8 }, { AT_TUCH, AD_PLYS, 1, 8 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 400, 0, MS_FERRY, MZ_HUMAN,
	  M1_NOPOLY | M1_SEE_INVIS | M1_HUMANOID | M1_POIS_RES | M1_FIRE_RES |
	  M1_GREEDY | M1_COLLECT, M2_HUMAN | M2_PEACEFUL | M2_PNAME,
	  C(WHITE) },
#endif
/*	Ghost		*/
	{ "ghost", S_GHOST, 10, 3, -5, 50, -5, (G_NOCORPSE | G_NOGEN),
	  { { AT_TUCH, AD_PHYS, 1, 1 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 0, PL_NSIZ, MS_SILENT, MZ_HUMAN,
	  M1_NOPOLY | M1_FLY | M1_WALLWALK | M1_HUMANOID | M1_POIS_RES,
	  M2_UNDEAD | M2_STALK | M2_HOSTILE, C(GRAY) },
/*	(major) Demons	*/
	{ "water demon", S_DEMON, 8, 12,-4, 30, -7, (G_NOCORPSE | G_NOGEN),
	  { { AT_WEAP, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_SILENT, MZ_HUMAN,
	  M1_SWIM | M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(BLUE) },
#ifndef INFERNO /* generic type */
	{ "demon", S_DEMON, 10, 12,-4, 30, -7, (G_NOCORPSE | 3),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_CUSS, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(RED) },
#else	/* used in hell for bigger, badder demons! */
	/* standard demons & devils */
	{ "horned devil", S_DEMON, 6, 9, -5, 50, 11, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 3 }, { AT_STNG, AD_PHYS, 1, 3 }, NO_ATTK },
	  45, 450, 0, MS_SILENT, MZ_HUMAN,
	  M1_POIS | M1_FIRE_RES | M1_THICK_HIDE,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(BROWN) },
#ifdef SEDUCE
	{ "succubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_BITE, AD_SSEX, 0, 0 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK },
	  45, 450, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_FEM, C(GRAY) },
	{ "incubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_BITE, AD_SSEX, 0, 0 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_CLAW, AD_PHYS, 1, 3 }, NO_ATTK },
	  45, 450, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(GRAY) },
#else
	{ "succubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_DRLI, 2, 6 }, NO_ATTK },
	  45, 450, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_FEM, C(GRAY) },
	{ "incubus", S_DEMON, 6, 12, 0, 70, -9, (G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_DRLI, 2, 6 }, NO_ATTK },
	  45, 450, 0, MS_SEDUCE, MZ_HUMAN,
	  M1_HUMANOID | M1_FLY | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(GRAY) },
#endif
	{ "erinyes", S_DEMON, 7, 12, 2, 30, 10,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_WEAP, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_SILENT, MZ_HUMAN,
	  M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY | M2_FEM,
	  C(RED) },
	{ "marilith", S_DEMON, 7, 12, -6, 80, -12, (G_HELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, { AT_WEAP, AD_PHYS, 2, 4 },
	    { AT_WEAP, AD_PHYS, 2, 4 }, }, 45, 450, 0, MS_CUSS, MZ_LARGE,
	  M1_HUMANOID | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES | M1_COLLECT |
	  M1_SLITHY,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY | M2_FEM, C(RED) },
	{ "barbed devil", S_DEMON, 8, 12, 0, 35, 8,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_STNG, AD_PHYS, 3, 4 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_SILENT, MZ_HUMAN,
	  M1_POIS | M1_FIRE_RES | M1_THICK_HIDE,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(RED) },
	{ "vrock", S_DEMON, 8, 12, 0, 50, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_CLAW, AD_PHYS, 1, 8 }, { AT_CLAW, AD_PHYS, 1, 8 },
	    { AT_BITE, AD_PHYS, 1, 6 }, },
	  45, 450, 0, MS_SILENT, MZ_LARGE, M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(RED) },
	{ "hezrou", S_DEMON, 9, 6, -2, 55, -10,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_CLAW, AD_PHYS, 1, 3 }, { AT_CLAW, AD_PHYS, 1, 3 },
	    { AT_BITE, AD_PHYS, 4, 4 }, NO_ATTK, NO_ATTK }, 45, 450, 0,
	  MS_SILENT, MZ_LARGE, M1_HUMANOID | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(RED) },
	{ "bone devil", S_DEMON, 9, 15, -1, 40, -9,
	  (G_HELL | G_NOCORPSE | G_SGROUP | 2),
	  { { AT_WEAP, AD_PHYS, 3, 4 }, { AT_STNG, AD_DRST, 2, 4 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 450, 0, MS_SILENT, MZ_LARGE,
	  M1_POIS | M1_FIRE_RES | M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(GRAY) },
	{ "nalfeshnee", S_DEMON, 11, 9, -1, 65, -11, (G_HELL | G_NOCORPSE | 1),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_MAGC, AD_SPEL, 0, 0 }, NO_ATTK },
	  45, 450, 0, MS_SILENT, MZ_LARGE,
	  M1_HUMANOID | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(RED) },
	{ "ice devil", S_DEMON, 11, 6, -4, 55, -12, (G_HELL | G_NOCORPSE | 2),
	  { { AT_CLAW, AD_PHYS, 1, 4 }, { AT_CLAW, AD_PHYS, 1, 4 },
	    { AT_BITE, AD_PHYS, 2, 4 }, { AT_STNG, AD_COLD, 3, 4 }, NO_ATTK },
	  45, 450, 0, MS_SILENT, MZ_LARGE,
	  M1_SEE_INVIS | M1_POIS | M1_FIRE_RES | M1_COLD_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(WHITE) },
	{ "pit fiend", S_DEMON, 13, 6, -3, 65, -13, (G_HELL | G_NOCORPSE | 2),
	  { { AT_WEAP, AD_PHYS, 4, 2 }, { AT_WEAP, AD_PHYS, 4, 2 },
	    { AT_HUGS, AD_PHYS, 2, 4 }, NO_ATTK, NO_ATTK },
	  45, 450, 0, MS_GROWL, MZ_LARGE,
	  M1_SEE_INVIS | M1_POIS | M1_FIRE_RES | M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_NASTY, C(RED) },
	{ "balrog", S_DEMON, 16, 5, -2, 75, -14, (G_HELL | G_NOCORPSE | 1),
	  { { AT_WEAP, AD_PHYS, 8, 4 }, { AT_WEAP, AD_PHYS, 4, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 45, 450, 0, MS_SILENT, MZ_LARGE,
	  M1_FLY | M1_SEE_INVIS | M1_COLLECT | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_STRONG | M2_NASTY, C(RED) },
	/* Named demon lords & princes plus Arch-Devils */
	{ "Juiblex", S_DEMON, 50, 3, -7, 65, -15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_ENGL, AD_DISE, 4, 10 }, { AT_SPIT, AD_ACID, 3, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 250, 0, MS_GURGLE, MZ_LARGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_ACID | M1_POIS | M1_FIRE_RES |
	  M1_AMORPHOUS,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_LORD,
	  C(BRIGHT|GREEN) },
	{ "Yeenoghu", S_DEMON, 56, 18, -5, 80, -15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 3, 6 }, { AT_WEAP, AD_CONF, 2, 8 },
	    { AT_WEAP, AD_PLYS, 1, 6 }, { AT_MAGC, AD_MAGM, 2, 6 }, NO_ATTK },
	  50, 500, 0, MS_ORC, MZ_LARGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_LORD,
	  C(HI_LORD) },
	{ "Orcus", S_DEMON, 66, 9, -6, 85, -20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 8, 6 }, { AT_WEAP, AD_PHYS, 3, 6 },
	    { AT_CLAW, AD_PHYS, 3, 4 }, { AT_CLAW, AD_PHYS, 3, 4 },
	    { AT_STNG, AD_DRST, 2, 4 }, }, 50, 500, 0, MS_ORC, MZ_HUGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE,
	  C(HI_LORD) },
	{ "Geryon", S_DEMON, 72, 3, -3, 75, 15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 3, 6 }, { AT_CLAW, AD_PHYS, 3, 6 },
	    { AT_STNG, AD_DRST, 2, 4 }, NO_ATTK, NO_ATTK },
	  50, 500, 0, MS_BRIBE, MZ_HUGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_SLITHY,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE, C(HI_LORD) },
	{ "Dispater", S_DEMON, 78, 15, -2, 80, 15,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_WEAP, AD_PHYS, 4, 6 }, { AT_MAGC, AD_SPEL, 6, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_BRIBE, MZ_HUMAN,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES |
	  M1_HUMANOID | M1_COLLECT,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE, C(HI_LORD) },
	{ "Baalzebub", S_DEMON, 89, 9, -5, 85, 20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_BITE, AD_DRST, 2, 6 }, { AT_GAZE, AD_STUN, 2, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_BRIBE, MZ_LARGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_POIS | M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE,
	  C(HI_LORD) },
	{ "Asmodeus", S_DEMON, 105, 12, -7, 90, 20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_CLAW, AD_PHYS, 4, 4 }, { AT_MAGC, AD_COLD, 6, 6 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 50, 500, 0, MS_BRIBE, MZ_HUGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_HUMANOID | M1_POIS |
	  M1_FIRE_RES | M1_COLD_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_STRONG | M2_NASTY |
	  M2_PRINCE, C(HI_LORD) },
	{ "Demogorgon", S_DEMON, 106, 15, -8, 95, -20,
	  (G_HELL | G_NOCORPSE | G_NOGEN | G_UNIQ),
	  { { AT_MAGC, AD_SPEL, 8, 6 }, { AT_STNG, AD_DRLI, 1, 4 },
	    { AT_CLAW, AD_DISE, 1, 6 }, { AT_CLAW, AD_DISE, 1, 6 },
	    NO_ATTK }, 50, 500, 0, MS_GROWL, MZ_HUGE,
	  M1_NOPOLY | M1_FLY | M1_SEE_INVIS | M1_NOHANDS | M1_POIS |
	  M1_FIRE_RES,
	  M2_DEMON | M2_STALK | M2_HOSTILE | M2_PNAME | M2_NASTY | M2_PRINCE,
	  C(HI_LORD) },
#endif
#ifdef MAIL
	{ "mail daemon", S_DEMON, 56, 24, 10, 127, 0, (G_NOGEN | G_NOCORPSE),
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK }, 30, 300, 0,
	  MS_SILENT, MZ_HUMAN, M1_NOPOLY | M1_FLY | M1_SWIM | M1_SEE_INVIS |
	  M1_HUMANOID | M1_POIS | M1_FIRE_RES | M1_COLD_RES | M1_SLEE_RES,
	  M2_STALK | M2_PEACEFUL, C(BRIGHT|BLUE) },
/* Neither rain nor sleet nor gloom of night shall stay this courier... */
#endif
	{ "djinni", S_DEMON, 7, 12, 4, 30, 0, (G_NOGEN | G_NOCORPSE),
	  { { AT_WEAP, AD_PHYS, 2, 8 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  40, 400, 0, MS_DJINNI, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_FLY | M1_POIS | M1_COLLECT, M2_STALK,
	  C(YELLOW) },
/*	sea monsters		*/
	{ "giant eel", S_EEL, 5, 9, -1, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_PHYS, 3, 6 }, { AT_TUCH, AD_WRAP, 0, 0 },
	    NO_ATTK, NO_ATTK, NO_ATTK }, 10, 250, 0, MS_SILENT, MZ_HUGE,
	  M1_SWIM | M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_NOPOLY,
	  M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(CYAN) },
	{ "electric eel", S_EEL, 7, 10, -3, 0, 0, (G_GENO | G_NOGEN),
	  { { AT_BITE, AD_ELEC, 4, 6 }, { AT_TUCH, AD_WRAP, 0, 0 },
	  NO_ATTK, NO_ATTK, NO_ATTK }, 10, 250, 0, MS_SILENT, MZ_HUGE,
	  M1_SWIM | M1_ANIMAL | M1_SLITHY | M1_NOLIMBS | M1_NOPOLY |
	  M1_ELEC_RES, M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BLUE) },
	{ "kraken", S_EEL, 20, 3, 6, 0, -3, (G_GENO | G_NOGEN),
	  { { AT_CLAW, AD_PHYS, 2, 4 }, { AT_CLAW, AD_PHYS, 2, 4 },
	    { AT_HUGS, AD_WRAP, 2, 6 }, { AT_BITE, AD_PHYS, 5, 4 }, NO_ATTK },
	  100, 1000, 0, MS_SILENT, MZ_HUGE,
	  M1_SWIM | M1_ANIMAL | M1_NOHANDS | M1_NOPOLY,
	  M2_HOSTILE | M2_STRONG | M2_CARNIVORE, C(RED) },
/*	lizards 	*/
	{ "newt", S_LIZARD, 0, 6, 8, 0, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 1, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SILENT, MZ_TINY, M1_SWIM | M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(YELLOW) },
	{ "gecko", S_LIZARD, 1, 6, 8, 0, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 1, 3 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  2, 20, 0, MS_SQEEK, MZ_TINY, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(GREEN) },
	{ "iguana", S_LIZARD, 2, 6, 7, 0, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  3, 30, 0, MS_SILENT, MZ_TINY, M1_ANIMAL | M1_NOHANDS,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "baby crocodile", S_LIZARD, 3, 6, 7, 0, 0, G_GENO,
	  { { AT_BITE, AD_PHYS, 1, 4 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  20, 200, 0, MS_SILENT, MZ_MEDIUM, M1_ANIMAL | M1_NOHANDS | M1_SWIM,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "lizard", S_LIZARD, 5, 6, 6, 10, 0, (G_GENO | 5),
	  { { AT_BITE, AD_PHYS, 1, 6 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  1, 40, 0, MS_SILENT, MZ_TINY, M1_ANIMAL | M1_NOHANDS | M1_STON_RES,
	  M2_HOSTILE | M2_CARNIVORE, C(GREEN) },
	{ "chameleon", S_LIZARD, 6, 5, 6, 10, 0, (G_GENO | 2),
	  { { AT_BITE, AD_PHYS, 4, 2 }, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  10, 100, 0, MS_SILENT, MZ_TINY, M1_ANIMAL | M1_NOHANDS | M1_NOPOLY,
	  M2_HOSTILE | M2_CARNIVORE, C(BROWN) },
	{ "crocodile", S_LIZARD, 6, 9, 5, 0, 0, (G_GENO | 1),
	  { { AT_BITE, AD_PHYS, 4, 2 }, { AT_CLAW, AD_PHYS, 1, 12 }, NO_ATTK,
	  NO_ATTK, NO_ATTK }, 45, 400, 0, MS_SILENT, MZ_LARGE,
	  M1_ANIMAL | M1_THICK_HIDE | M1_NOHANDS | M1_SWIM,
	  M2_STRONG | M2_HOSTILE | M2_CARNIVORE | M2_EGGS, C(BROWN) },

/*	character classes */
	{ "archeologist", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_TUNNEL | M1_NEEDPICK,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "barbarian", S_HUMAN, 1, 10, 10, 1, -3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_POIS_RES,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "caveman", S_HUMAN, 1, 10, 10, 0, 1, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 2, 4}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG | M2_CARNIVORE, C(RED) },
	{ "cavewoman", S_HUMAN, 1, 10, 10, 0, 1, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 2, 4}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG | M2_CARNIVORE | M2_FEM, C(HI_DOMESTIC) },
	/* Note: players who are elves still get normal carrying capacity,
	 * even though this is strictly speaking inconsistent.
	 */
	{ "elf", S_HUMAN, 1, 12, 10, 2, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 8}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  35, 350, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_SLEE_RES | M1_SEE_INVIS,
	  M2_ELF | M2_STRONG, C(HI_DOMESTIC) },
	{ "healer", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_POIS_RES,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "knight", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "priest", S_HUMAN, 1, 10, 10, 2, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "priestess", S_HUMAN, 1, 10, 10, 2, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG | M2_FEM, C(HI_DOMESTIC) },
	{ "rogue", S_HUMAN, 1, 10, 10, 1, -3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_GREEDY,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "samurai", S_HUMAN, 1, 10, 10, 1, 3, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 8}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "tourist", S_HUMAN, 1, 10, 10, 1, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },
	{ "valkyrie", S_HUMAN, 1, 10, 10, 1, -1, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 8}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_COLD_RES,
	  M2_HUMAN | M2_STRONG | M2_FEM, C(HI_DOMESTIC) },
	{ "wizard", S_HUMAN, 1, 10, 10, 3, 0, G_NOGEN,
	  { {AT_WEAP, AD_PHYS, 1, 6}, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  45, 400, 0, MS_HUMANOID, MZ_HUMAN,
	  M1_NOPOLY | M1_HUMANOID | M1_COLLECT | M1_MAGIC,
	  M2_HUMAN | M2_STRONG, C(HI_DOMESTIC) },

/*	ARRAY TERMINATOR	*/
	{ "", 0, 0, 0, 0, 0, 0, 0,
	  { NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK, NO_ATTK },
	  0, 0, 0, 0, 0, 0, 0, C(0) }
};
#endif /* !SPLITMON_1 */
#endif /* !MAKEDEFS_C */
