


RECOVER(6)                    1993                     RECOVER(6)



NAME
     recover - recover a NetHack game interrupted by disaster

SYNOPSIS
     recover [ -d directory ] base1 base2 ...

DESCRIPTION
     Occasionally, a NetHack game will be interrupted by disaster
     when the game or the system crashes.  Prior to NetHack v3.1,
     these games were lost because various information  like  the
     player's  inventory  was kept only in memory.  Now, all per-
     tinent information can be written out to disk, so such games
     can be recovered at the point of the last level change.

     The base options tell recover which files to process.   Each
     base option specifies recovery of a separate game.

     The -d option, which  must  be  the  first  argument  if  it
     appears,  supplies  a  directory  which is the NetHack play-
     ground.  It overrides the value from NETHACKDIR, HACKDIR, or
     the  directory  specified  by  the game administrator during
     compilation (usually /usr/games/lib/nethackdir).

     For recovery to be possible, nethack must have been compiled
     with  the  INSURANCE  option, and the run-time option check-
     point must also have been on.  NetHack normally  writes  out
     files  for levels as the player leaves them, so they will be
     ready for return visits.  When checkpointing,  NetHack  also
     writes  out  the level entered and the current game state on
     every level change.  This naturally slows level changes down
     somewhat.

     The level file names are of the form base.nn, where nn is an
     internal  bookkeeping number for the level.  The file base.0
     is used for game identity, locking, and, when checkpointing,
     for  the  game state.  Various OSes use different strategies
     for constructing the  base  name.   Microcomputers  use  the
     character  name,  possibly  truncated  and  modified to be a
     legal filename on that system.  Multi-user systems  use  the
     (modified) character name prefixed by a user number to avoid
     conflicts, or "xlock" if the number of concurrent players is
     being  limited.   It  may  be necessary to look in the play-
     ground to find the correct  base  name  of  the  interrupted
     game.   recover will transform these level files into a save
     file of the same name as nethack would have used.

     Since recover must be able to read and delete files from the
     playground  and  create  files in the save directory, it has
     interesting interactions with game security.   Giving  ordi-
     nary  players  access to recover through setuid or setgid is
     tantamount to leaving the  playground  world-writable,  with
     respect  to both cheating and messing up other players.  For



January                  Last change: 9                         1






RECOVER(6)                    1993                     RECOVER(6)



     a single-user system, this of course does  not  change  any-
     thing, so some of the microcomputer ports install recover by
     default.

     For a multi-user system, the game administrator may want  to
     arrange  for  all  .0  files  in the playground to be fed to
     recover when the host machine boots, and handle game crashes
     individually.    If  the  user  population  is  sufficiently
     trustworthy, recover can be installed with the same  permis-
     sions  the  nethack executable has.  In either case, recover
     is easily compiled from the distribution utility directory.

NOTES
     Like nethack itself, recover will overwrite  existing  save-
     files  of  the  same name.  Savefiles created by recover are
     uncompressed; they may be compressed afterwards if  desired,
     but  even  a compression-using nethack will find them in the
     uncompressed form.

SEE ALSO
     nethack(6)

BUGS
     recover makes no attempt to find out if a base  name  speci-
     fies a game in progress.  If multiple machines share a play-
     ground, this would be impossible to determine.

     recover should be taught to use the nethack playground lock-
     ing mechanism to avoid conflicts.


























January                  Last change: 9                         2



